// Prezentacja kontrolki ListView
 
import javafx.application.*; 
import javafx.scene.*; 
import javafx.stage.*; 
import javafx.scene.layout.*; 
import javafx.scene.control.*; 
import javafx.geometry.*; 
import javafx.beans.value.*; 
import javafx.collections.*; 
 
public class ListViewDemo extends Application { 
 
  Label response; 
 
  public static void main(String[] args) { 
 
    // Uruchamia aplikację JavaFX, wywołując metodę launch(). 
    launch(args);   
  } 
 
  // Przesłonięcie metody start(). 
  public void start(Stage myStage) { 
 
    // Określa tytuł obszaru roboczego. 
    myStage.setTitle("Prezentacja kontrolki ListView"); 
 
    // Jako korzeń zostaje użyty panel FlowPane. W tym 
    // przypadku pionowe i poziome odstępy pomiędzy umieszczonymi
    // w nim kontrolkami będą wynosić 10. 
    FlowPane rootNode = new FlowPane(10, 10); 
 
    // Wyrównuje kontrolki do środka.
    rootNode.setAlignment(Pos.CENTER); 
 
    // Tworzy obiekt Scene. 
    Scene myScene = new Scene(rootNode, 200, 120); 
 
    // Dodaje obiekt Scene do obiektu Stage. 
    myStage.setScene(myScene); 
 
    // Tworzy etykietę. 
    response = new Label("Wybierz typ komputera"); 
 
    // Tworzy listę ObservableList, zawierającą elementy, które
    // mają być wyświetlone w kontrolce listy. 
    ObservableList<String> computerTypes = 
      FXCollections.observableArrayList("Smartfon", "Tablet", "Notebook", 
                                        "Stacjonarny" );  
 
    // Tworzy kontrolkę ListView
    ListView<String> lvComputers = new ListView<String>(computerTypes); 
 
    // Określa preferowaną wysokość i szerokość.
    lvComputers.setPrefSize(100, 70); 
 
    // Pobiera model zaznaczania elementów listy.
    MultipleSelectionModel<String> lvSelModel = 
                                     lvComputers.getSelectionModel(); 
 
    // Tworzy obiekt nasłuchujący zdarzeń, który będzie odpowiadał na 
    // zmiany zaznaczenia elementów listy.
    lvSelModel.selectedItemProperty().addListener( 
                                      new ChangeListener<String>() { 
      public void changed(ObservableValue<? extends String> changed, 
                          String oldVal, String newVal) { 
 
        // Wyświetla nazwę wybranego elementu listy. 
        response.setText("Wybranym typem komputera jest: " + newVal); 
      } 
    }); 
 
    // Dodaje etykietę i kontrolkę listy do grafu sceny.
    rootNode.getChildren().addAll(lvComputers, response); 
 
    // Wyświetla scenę i obszar roboczy. 
    myStage.show(); 
  } 
}
