// Zastosowanie wyrażenia lambda jako argumentu metody. 
 
interface StringFunc { 
  String func(String str); 
} 
 
class LambdaArgumentDemo { 
 
  // W tej metodzie typem pierwszego parametru jest interfejs 
  // funkcyjny. Oznacza to, że można do niej przekazać dowolną 
  // referencję instancji tego typu, w tym także instancji 
  // utworzonej przy użyciu wyrażenia lambda. Drugi parametr 
  // określa łańcuch znakowy, na którym należy operować.
  static String changeStr(StringFunc sf, String s) { 
    return sf.func(s); 
  } 
 
  public static void main(String args[]) 
  { 
    String inStr = "Wyrażenia lambda rozszerzają możliwości Javy"; 
    String outStr; 
 
    System.out.println("Łańcuch wejściowy: " + inStr); 
 
    // Definiuje wyrażenie lambda, które odwraca kolejność 
    // znaków w łańcuchu i zapisuje je w zmiennej referencyjnej
    // typu StringFunc. 
    StringFunc reverse = (str) ->  { 
      String result = ""; 
 
      for(int i = str.length()-1; i >= 0; i--) 
        result += str.charAt(i); 
 
      return result; 
    }; 
 
    // Przekazuje wartość zmiennej reverse jako pierwszy argument
    // wywołania metody changeStr(). 
    // Drugim argumentem jest wejściowy łańcuch znakowy. 
    outStr = changeStr(reverse, inStr); 
    System.out.println("Odwrócony łańcuch znakowy: " + outStr); 
 
    // To wyrażenie lambda zamienia znaki odstępu na minusy.
    // Podano je bezpośrednio w wywołaniu metody changeStr().
    outStr = changeStr((str) -> str.replace(' ', '-'), inStr); 
    System.out.println("Łańcuch z zamienionymi odstępami: " + outStr); 
 
    // To blokowe wyrażenie lambda zmienia małe litery na wielkie 
    // i wielkie na małe. Także ono zostało podane bezpośrednio 
    // w wywołaniu metody changeStr().
    outStr = changeStr((str) -> { 
                         String result = ""; 
                         char ch; 
 
                         for(int i = 0; i < str.length(); i++ ) { 
                           ch = str.charAt(i); 
                           if(Character.isUpperCase(ch)) 
                             result += Character.toLowerCase(ch); 
                           else  
                             result += Character.toUpperCase(ch); 
                         } 
                         return result; 
                       }, inStr); 
 
    System.out.println("Łańcuch ze zmienioną wielkością liter: " + outStr); 
  } 
}
