// Prezentacja użycia metody Platform.exit().  
  
import javafx.application.*;  
import javafx.scene.*;  
import javafx.stage.*;  
import javafx.scene.layout.*;  
import javafx.scene.control.*;  
import javafx.event.*;  
import javafx.geometry.*;  
  
public class JavaFXEventDemo extends Application {  
  
  Label response;  
  
  public static void main(String[] args) {  
  
    // Uruchamia aplikację JavaFX, wywołując metodę launch().  
    launch(args);    
  }  
  
  // Przesłonięcie metody start(). 
  public void start(Stage myStage) {  
  
    // Określa tytuł obszaru roboczego. 
    myStage.setTitle("Zastosowanie metody Platform.exit()");  
  
    // Jako korzeń zostaje użyty panel FlowPane. W tym 
    // przypadku pionowe i poziome odstępy pomiędzy umieszczonymi
    // w nim kontrolkami będą wynosić 10. 
    FlowPane rootNode = new FlowPane(10, 10);  
  
    // Wyrównuje kontrolki do środka.
    rootNode.setAlignment(Pos.CENTER);  
  
    // Tworzy obiekt Scene. 
    Scene myScene = new Scene(rootNode, 300, 100);  
  
    // Dodaje obiekt Scene do obiektu Stage. 
    myStage.setScene(myScene);  
  
    // Tworzy etykietę. 
    response = new Label("Naciśnij przycisk");  
  
    // Tworzy dwa przyciski. 
    Button btnRun = new Button("Uruchom");  
    Button btnExit = new Button("Zakończ");  
  
    // Obsługa zdarzenia ActionEvent przycisku Uruchom.
    btnRun.setOnAction((ae) -> response.setText("Kliknąłeś przycisk Uruchom.")); 
  
    // Obsługa zdarzenia ActionEvent przycisku Zakończ.
    btnExit.setOnAction((ae) -> Platform.exit());  
  
    // Dodaje etykietę i przyciski do grafu sceny.
    rootNode.getChildren().addAll(btnRun, btnExit, response);  
  
    // Wyświetla scenę i obszar roboczy.
    myStage.show();  
  }  
}