// Wyjątek przepełnienia stosu.  
class StackFullException extends Exception {  
  int size;  
    
  StackFullException(int s) { size = s; }  
  
  public String toString() {  
   return "\nStos jest pełen. Maksymalny rozmiar: " +  
           size;  
  }  
}  
  
// Wyjątek opróżnienia stosu.  
class StackEmptyException extends Exception {  
  
  public String toString() {  
   return "\nStos jest pusty.";  
  }  
}  
  
// Klasa implementująca stos znaków.    
class Stack {    
  private char stck[]; // tablica przechowująca elementy stosu 
  private int tos;  // szczyt stosu   
    
  // Tworzy pusty stos o podanym rozmiarze. 
  Stack(int size) {    
    stck = new char[size]; // przydziela pamięć stosu 
    tos = 0;    
  }    
   
  // Tworzy stos na podstawie innego stosu. 
  Stack(Stack ob) {   
    tos = ob.tos;   
    stck = new char[ob.stck.length];   
   
    // kopiuje elementy   
    for(int i=0; i < tos; i++)   
      stck[i] = ob.stck[i];   
  }   
   
  // Tworzy stos zawierający podane elementy początkowe. 
  Stack(char a[]) {   
    stck = new char[a.length];   
   
    for(int i = 0; i < a.length; i++) {   
      try {  
        push(a[i]);   
      }   
      catch(StackFullException exc) {  
        System.out.println(exc);  
      }  
    }       
  }   
      
  // Odkłada znak na stosie.   
  void push(char ch) throws StackFullException {    
    if(tos==stck.length)  
      throw new StackFullException(stck.length);  
 
    stck[tos] = ch;   
    tos++;   
  }    
    
  // Zdejmuje znak ze stosu. 
  char pop() throws StackEmptyException {    
    if(tos==0)    
      throw new StackEmptyException();  
      
    tos--;    
    return stck[tos];    
  }    
}
