// Uywa pole tekstowe. 
 
import java.awt.*; 
import java.awt.event.*; 
import javax.swing.*; 
  
class TFDemo implements ActionListener { 
 
  JTextField jtf; 
  JButton jbtnRev; 
  JLabel jlabPrompt, jlabContents;  
 
  TFDemo() { 
 
    // Tworzy nowy kontener JFrame. 
    JFrame jfrm = new JFrame("Pole tekstowe"); 
 
    // Wybiera FlowLayout jako menedera ukadu. 
    jfrm.setLayout(new FlowLayout()); 
 
    // Nadaje oknu pocztkowe rozmiary. 
    jfrm.setSize(240, 120); 
 
    // Aplikacja zakoczy dziaanie na skutek zamknicia okna. 
    jfrm.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE); 
 
    // Tworzy pole tekstowe. 
    jtf = new JTextField(10); 
 
    // Konfiguruje tekst zwizany z polem tekstowym. 
    jtf.setActionCommand("myTF"); 
 
    // Tworzy przycisk Odwr. 
    JButton jbtnRev = new JButton("Odwr"); 
 
    // Dodaje obiekty nasuchujce zdarze. 
    jtf.addActionListener(this); 
    jbtnRev.addActionListener(this); 
 
    // Tworzy etykiety. 
    jlabPrompt = new JLabel("Wprowad tekst: "); 
    jlabContents = new JLabel(""); 
 
    // Umieszcza komponenty w panelu zawartoci. 
    jfrm.add(jlabPrompt); 
    jfrm.add(jtf);  
    jfrm.add(jbtnRev);  
    jfrm.add(jlabContents); 
 
    // Wywietla okno. 
    jfrm.setVisible(true); 
  } 
 
  // Obsuga zdarze ActionEvent. 
  public void actionPerformed(ActionEvent ae) { 
   
    if(ae.getActionCommand().equals("Odwr")) { 
      // Przycisk Odwr zosta nacinity.  
      String orgStr = jtf.getText(); 
      String resStr = ""; 
 
      // Odwraca zawarto pola tekstowego. 
      for(int i=orgStr.length()-1; i >=0; i--) 
        resStr += orgStr.charAt(i); 
 
      // Umieszcza odwrcony acuch w polu tekstowym. 
      jtf.setText(resStr);  
    } else 
      // Uytkownik nacisn Enter podczas wprowadzania  
      // tekstu w polu tekstowym. 
      jlabContents.setText("Nacisne Enter. Tekst: " + 
                           jtf.getText()); 
  } 
 
  public static void main(String args[]) { 
    // Tworzy okno w wtku rozdziau zdarze. 
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() { 
        new TFDemo(); 
      } 
    }); 
  } 
}
