// Uywa wasnego wyjtku. 
 
// Tworzy klas wyjtku. 
class NonIntResultException extends Exception { 
  int n; 
  int d; 
 
  NonIntResultException(int i, int j) { 
    n = i; 
    d = j; 
  } 
 
  public String toString() { 
    return "Wynik dzielenia " + n + " / " + d + 
           " nie jest wartoci cakowit."; 
  } 
} 
 
class CustomExceptDemo { 
  public static void main(String args[]) { 
 
    // Tablica numer zawiera dwie nieparzyste wartoci. 
    int numer[] = { 4, 8, 15, 32, 64, 127, 256, 512 }; 
    int denom[] = { 2, 0, 4, 4, 0, 8 }; 
    for(int i=0; i<numer.length; i++) { 
      try { 
        if((numer[i]%2) != 0) 
          throw new  
            NonIntResultException(numer[i], denom[i]); 
 
        System.out.println(numer[i] + " / " + 
                           denom[i] + " rwna si " + 
                           numer[i]/denom[i]); 
      } 
      catch (ArithmeticException exc) { 
        // przechwytuje wyjtek
        System.out.println("Nie wolno dzieli przez zero!"); 
      } 
      catch (ArrayIndexOutOfBoundsException exc) { 
        // przechwytuje wyjtek
        System.out.println("Brak odpowiedniego elementu tablicy."); 
      } 
      catch (NonIntResultException exc) { 
        System.out.println(exc); 
      } 
    } 
  } 
}
