/* Wywietla plik tekstowy. 
 
   Uruchamiajc ten program, podaj nazw pliku,  
   ktrego zawarto chcesz zobaczy.
   Na przykad aby wywietli zawarto pliku TEST.TXT, 
   uyj poniszego wywoania. 
 
   java -D file.encoding=CP852 ShowFile TEST.TXT 
*/ 
 
import java.io.*; 
 
class ShowFile { 
  public static void main(String args[])  
  { 
    int i; 
    FileInputStream fin; 
 
    // Upewnia si, e podano nazw pliku.
    if(args.length != 1) {
      System.out.println("Sposb uycia: ShowFile NazwaPliku"); 
      return;
    }

    try { 
      fin = new FileInputStream(args[0]); 
    } catch(FileNotFoundException exc) { 
      System.out.println("Plik nie zosta znaleziony."); 
      return; 
    }

    try { 
      // wczytuje bajty do napotkania koca pliku 
      do { 
        i = fin.read(); 
        if(i != -1) System.out.print((char) i); 
      } while(i != -1); 
    } catch(IOException exc) {
      System.out.println("Bd podczas odczytu pliku.");
    }

    try {
      fin.close(); 
    } catch(IOException exc) {
      System.out.println("Bd podczas zamykania pliku.");
    }

  } 
}
