/* Ta wersja programu umieszcza kod otwierajcy plik
   i czytajcy jego zawarto we wsplnym bloku try.
   Plik zostaje zamknity przez blok finally.
*/

import java.io.*;

class ShowFile2 {
  public static void main(String args[])
  {
    int i;
    FileInputStream fin = null;

    // Upewnij si, e podano nazw pliku.
    if(args.length != 1) {
      System.out.println("Sposb uycia: ShowFile2 NazwaPliku");
      return;
    }

    // Poniszy kod otwiera plik, wczytuje bajty 
    // a do napotkania koca pliku 
    // i zamyka plik w bloku finally .
    try {
      fin = new FileInputStream(args[0]);

      do {
        i = fin.read();
        if(i != -1) System.out.print((char) i);
      } while(i != -1);

    } catch(FileNotFoundException exc) {
      System.out.println("Plik nie zosta znaleziony.");
    } catch(IOException exc) {
      System.out.println("Wystapi bd wejcia/wyjcia.");
    } finally {
      // Zawsze zamyka plik.
      try {
        if(fin != null) fin.close();
      } catch(IOException exc) {
        System.out.println("Bd podczas zamykania pliku");
      }
    }
  }
}
