// Wprowadza kolejne konstruktory klasy TwoDShape. 
class TwoDShape { 
  private double width; 
  private double height; 
 
  //Konstruktor domylny. 
  TwoDShape() { 
    width = height = 0.0; 
  } 
 
  // Konstruktor z dwoma parametrami. 
  TwoDShape(double w, double h) { 
    width = w; 
    height = h; 
  } 
 
  // Tworzy obiekt, ktrego szeroko jest taka sama jak wysoko. 
  TwoDShape(double x) { 
    width = height = x; 
  } 
 
  // Metody dostpowe dla skadowych width i height. 
  double getWidth() { return width; } 
  double getHeight() { return height; } 
  void setWidth(double w) { width = w; } 
  void setHeight(double h) { height = h; } 
 
  void showDim() { 
    System.out.println("Szeroko i wysoko: " + 
                       width + " and " + height); 
  } 
} 
 
// Klasa pochodna klasy bazowej TwoDShape reprezentujca trjkty. 
class Triangle extends TwoDShape { 
  private String style; 
   
  // Konstruktor domylny. 
  Triangle() { 
    super(); 
    style = "nieokrelony"; 
  } 
 
  // Konstruktor 
  Triangle(String s, double w, double h) { 
    super(w, h); // wywoanie konstruktora klasy bazowej
 
    style = s;  
  } 
 
  // Konstruktor o jednym parametrze. 
  Triangle(double x) { 
    super(x); // wywoanie konstruktora klasy bazowej
 
    style = "wypeniony";  
  } 
 
  double area() { 
    return getWidth() * getHeight() / 2; 
  } 
 
  void showStyle() { 
    System.out.println("Trjkt jest " + style); 
  } 
} 
 
class Shapes5 { 
  public static void main(String args[]) { 
    Triangle t1 = new Triangle(); 
    Triangle t2 = new Triangle("pusty", 8.0, 12.0); 
    Triangle t3 = new Triangle(4.0); 
 
    t1 = t2; 
 
    System.out.println("Informacje o t1: "); 
    t1.showStyle(); 
    t1.showDim(); 
    System.out.println("Powierzchnia wynosi " + t1.area()); 
 
    System.out.println(); 
 
    System.out.println("Informacje o t2: "); 
    t2.showStyle(); 
    t2.showDim(); 
    System.out.println("Powierzchnia wynosi " + t2.area()); 
 
    System.out.println(); 
 
    System.out.println("Informacje o t3: "); 
    t3.showStyle(); 
    t3.showDim(); 
    System.out.println("Powierzchnia wynosi " + t3.area()); 
 
    System.out.println(); 
  } 
}
