package javanut8.ch04.shapes;

public final class Rectangle extends Shape implements Rotate90 {
	private double w, h;                               // Dane egzemplarza
	public Rectangle(double w, double h) {               // Konstruktor
		this.w = w;
		this.h = h;
	}
	public double getWidth() { return w; }               // Metoda dostępowa
	public double getHeight() { return h; }              // Inna metoda dostępowa
	  
	@Override
	public double area() { return w*h; }                 // Implementacje metod abstrakcyjnych.

	@Override
	public double circumference() { return 2*(w + h); }

	@Override
	public void clockwise() {
		// Zamiana szerokości i wysokości
		double tmp = w;
		w = h;
		h = tmp;
	}

	@Override
	public void antiClockwise() {
		// Zamiana szerokości i wysokości
		double tmp = w;
		w = h;
		h = tmp;
	}
}
