package javanut8.ch07;

/**
 * Ta niezmienna klasa reprezentuje <i>liczby zespolone</i>.
 *
 * @author David Flanagan
 * @version 1.0
 */
public class Complex {
    /**
     * Przechowuje część rzeczywistą liczby zespolonej.
     * @see #y
     */
  protected double x;

  /**
   * Przechowuje część urojoną liczby zespolonej.
   * @see #x
  */
  protected double y;

  /**
   * Tworzy nowy obiekt typu Complex reprezentujący liczbę
   * zespoloną x+yi. @param x Część rzeczywista liczby zespolonej.
   * @param y Część urojona liczby zespolonej.
   */
  public Complex(double x, double y) {
    this.x = x;
    this.y = y;
  }

  /**
   * Sumuje dwa obiekty typu Complex i tworzy trzeci obiekt
   * reprezentujący tę sumę.
   * @param c1 Obiekt typu Complex
   * @param c2 Inny obiekt typu Complex
   * @return Nowy obiekt typu Complex reprezentujący sumę
   * obiektów <code>c1</code> i <code>c2</code>.
   * @exception java.lang.NullPointerException
   * Jeśli którykolwiek z argumentów jest <code>null</code>.
   */
  public static Complex add(Complex c1, Complex c2) {
   return new Complex(c1.x + c2.x, c1.y + c2.y);
  }
}
