package org.jpwh.test.service;

import org.jpwh.web.jsf.AuctionService;
import org.testng.annotations.Test;

import javax.inject.Inject;

import static org.testng.Assert.assertEquals;

public class AuctionServiceTest extends IntegrationTest {

    @Inject
    AuctionService service;

    @Test
    public void placeBid() {
        service.setId(1);

        assertEquals(service.getItem().getName(), "Rękawica do baseballa");
        assertEquals(service.getHighestBidAmount().toString(), "13.00");

        // TODO: Wymaga JSFUnit, który obecnie jest w wersji beta. 

           JSF jest trudny do testowania. Najlepszym wyjściem wydaje się testowanie funkcjonalne interfejsu UI
           za pomocą takich narzędzi, jak Selenium lub HTMLUnit.

        // Za nisko
        service.setNewBidAmount(new BigDecimal("12.00"));
        String outcome = service.placeBid();
        assertTrue(!outcome.contains("redirect"));
        assertTrue(FacesContext.getCurrentInstance().getMessageList().size() > 0);

        // OK
        service.setNewBidAmount(new BigDecimal("14.00"));
        outcome = service.placeBid();
        assertTrue(outcome.contains("redirect"));
        assertTrue(FacesContext.getCurrentInstance().getMessageList().size() == 0);
        */

    }
}

