package org.jpwh.env;

import bitronix.tm.resource.jdbc.PoolingDataSource;

import java.util.Properties;

public enum DatabaseProduct {

    H2(
        new DataSourceConfiguration() {
            @Override
            public void configure(PoolingDataSource ds, String connectionURL) {
                ds.setClassName("org.h2.jdbcx.JdbcDataSource");

                // Egzemplarz zewnętrzny: jdbc:h2:tcp://localhost/mem:test;USER=sa
                ds.getDriverProperties().put(
                    "URL",
                    connectionURL != null
                        ? connectionURL :
                        "jdbc:h2:mem:test"
                );

                // TODO: http://code.google.com/p/h2database/issues/detail?id=502
                ds.getDriverProperties().put("user", "sa");

                // TODO: Wyłączenie ze śledzenia wartości loga większych niż X bajtów (szczególnie przydatne do
                // debugowania obiektów LOB, które są przekazywane do metody toString()!)
                // System.setProperty("h2.maxTraceDataLength", "256"); 256 bajtów, domyślnie 64 kilobajty
            }
        },
        org.jpwh.shared.ImprovedH2Dialect.class.getName()
    ),

    ORACLE(
        new DataSourceConfiguration() {
            @Override
            public void configure(PoolingDataSource ds, String connectionURL) {
                ds.setClassName("oracle.jdbc.xa.client.OracleXADataSource");
                ds.getDriverProperties().put(
                    "URL",
                    connectionURL != null
                        ? connectionURL :
                        "jdbc:oracle:thin:test/test@192.168.56.101:1521:xe"
                );

                // Wymagane do łatwego czytania kolumn VARBINARY/LONG RAW, patrz
                // http://stackoverflow.com/questions/10174951
                Properties connectionProperties = new Properties();
                connectionProperties.put("useFetchSizeWithLongColumn", "true");
                ds.getDriverProperties().put("connectionProperties", connectionProperties);
            }
        },
        org.hibernate.dialect.Oracle10gDialect.class.getName()
    ),

    POSTGRESQL(
        new DataSourceConfiguration() {
            @Override
            public void configure(PoolingDataSource ds, String connectionURL) {
                ds.setClassName("org.postgresql.xa.PGXADataSource");
                if (connectionURL != null) {
                    throw new IllegalArgumentException(
                        "PostgreSQL XADataSource nie wspiera adresów URL połączeń"
                    );
                }
                ds.getDriverProperties().put("serverName", "10.0.0.2");
                ds.getDriverProperties().put("databaseName", "test");
                ds.getDriverProperties().put("user", "test");
                ds.getDriverProperties().put("password", "test");
            }
        },
        org.hibernate.dialect.PostgreSQL82Dialect.class.getName()
    ),

    MYSQL(
        new DataSourceConfiguration() {
            @Override
            public void configure(PoolingDataSource ds, String connectionURL) {
                // TODO: Wsparcie dla MySQL XA całkowicie nie działa. Używamy wrappera BTM XA
                //ds.setClassName("com.mysql.jdbc.jdbc2.optional.MysqlXADataSource");
                ds.setClassName("bitronix.tm.resource.jdbc.lrc.LrcXADataSource");
                ds.getDriverProperties().put(
                    "url",
                    connectionURL != null
                        ? connectionURL :
                        "jdbc:mysql://localhost/test?sessionVariables=sql_mode='PIPES_AS_CONCAT'"
                );

                ds.getDriverProperties().put("driverClassName", "com.mysql.jdbc.Driver");
            }
        },
        // Tak, to powinno działać w wersji 5.6. Nie wiadomo, dlaczego Gail nadał nazwę 5.7
        org.hibernate.dialect.MySQL57InnoDBDialect.class.getName()
    );

    public DataSourceConfiguration configuration;
    public String hibernateDialect;

    private DatabaseProduct(DataSourceConfiguration configuration,
                            String hibernateDialect) {
        this.configuration = configuration;
        this.hibernateDialect = hibernateDialect;
    }

    public interface DataSourceConfiguration {

        void configure(PoolingDataSource ds, String connectionURL);
    }

}

