/*
 * Decompiled with CFR 0.152.
 */
package webstart;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.EventHandler;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.jnlp.BasicService;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.PersistenceService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import webstart.CalculatorPanel;

public class CalculatorFrame
extends JFrame {
    private CalculatorPanel panel;

    public CalculatorFrame() {
        this.setTitle();
        this.panel = new CalculatorPanel();
        this.add(this.panel);
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = jMenu.add("Open");
        jMenuItem.addActionListener(EventHandler.create(ActionListener.class, this, "open"));
        JMenuItem jMenuItem2 = jMenu.add("Save");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalculatorFrame.this.save();
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        this.pack();
    }

    public void setTitle() {
        try {
            String string = null;
            BasicService basicService = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            URL uRL = basicService.getCodeBase();
            PersistenceService persistenceService = (PersistenceService)ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
            URL uRL2 = new URL(uRL, "title");
            try {
                FileContents fileContents = persistenceService.get(uRL2);
                InputStream inputStream = fileContents.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                string = bufferedReader.readLine();
            }
            catch (FileNotFoundException fileNotFoundException) {
                string = JOptionPane.showInputDialog("Please supply a frame title:");
                if (string == null) {
                    return;
                }
                persistenceService.create(uRL2, 100L);
                FileContents fileContents = persistenceService.get(uRL2);
                OutputStream outputStream = fileContents.getOutputStream(true);
                PrintStream printStream = new PrintStream(outputStream);
                printStream.print(string);
            }
            this.setTitle(string);
        }
        catch (UnavailableServiceException unavailableServiceException) {
            JOptionPane.showMessageDialog(this, (Object)unavailableServiceException);
        }
        catch (MalformedURLException malformedURLException) {
            JOptionPane.showMessageDialog(this, malformedURLException);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, iOException);
        }
    }

    public void open() {
        try {
            FileOpenService fileOpenService = (FileOpenService)ServiceManager.lookup((String)"javax.jnlp.FileOpenService");
            FileContents fileContents = fileOpenService.openFileDialog(".", new String[]{"txt"});
            JOptionPane.showMessageDialog(this, fileContents.getName());
            if (fileContents != null) {
                String string;
                InputStream inputStream = fileContents.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((string = bufferedReader.readLine()) != null) {
                    this.panel.append(string);
                    this.panel.append("\n");
                }
            }
        }
        catch (UnavailableServiceException unavailableServiceException) {
            JOptionPane.showMessageDialog(this, (Object)unavailableServiceException);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, iOException);
        }
    }

    public void save() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            printStream.print(this.panel.getText());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            FileSaveService fileSaveService = (FileSaveService)ServiceManager.lookup((String)"javax.jnlp.FileSaveService");
            fileSaveService.saveFileDialog(".", new String[]{"txt"}, (InputStream)byteArrayInputStream, "calc.txt");
        }
        catch (UnavailableServiceException unavailableServiceException) {
            JOptionPane.showMessageDialog(this, (Object)unavailableServiceException);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, iOException);
        }
    }
}

