import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;

/**
 * Niniejszy program udowadnia, e wtek dziaajcy rwnolegle z wtkiem dystrybucji zdarze moe
 * powodowa bdy w komponentach Swing.
 * @version 1.23 2007-05-17
 * @author Cay Horstmann
 */
public class SwingThreadTest
{
   public static void main(String[] args)
   {
      EventQueue.invokeLater(new Runnable()
         {
            public void run()
            {
               SwingThreadFrame frame = new SwingThreadFrame();
               frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
               frame.setVisible(true);
            }
         });
   }
}

/**
 * Niniejsza ramka ma dwa przyciski suce do zapeniania listy w osobnym wtku. Przycisk Dobry wykorzystuje
 * kolejk zdarze, a Zy modyfikuje list bezporednio.
 */
class SwingThreadFrame extends JFrame
{
   public SwingThreadFrame()
   {
      setTitle("SwingThreadTest");

      final JComboBox combo = new JComboBox();
      combo.insertItemAt(Integer.MAX_VALUE, 0);
      combo.setPrototypeDisplayValue(combo.getItemAt(0));
      combo.setSelectedIndex(0);

      JPanel panel = new JPanel();

      JButton goodButton = new JButton("Dobry");
      goodButton.addActionListener(new ActionListener()
         {
            public void actionPerformed(ActionEvent event)
            {
               new Thread(new GoodWorkerRunnable(combo)).start();
            }
         });
      panel.add(goodButton);
      JButton badButton = new JButton("Zy");
      badButton.addActionListener(new ActionListener()
         {
            public void actionPerformed(ActionEvent event)
            {
               new Thread(new BadWorkerRunnable(combo)).start();
            }
         });
      panel.add(badButton);

      panel.add(combo);
      add(panel);
      pack();
   }
}

/**
 * Niniejsza klasa modyfikuje list rozwijaln dodajc do niej i usuwajc z niej losowe liczby. Moe to spowodowa bdy,
 * poniewa metody listy rozwijalnej nie s synchronizowane, przez co wtek roboczy i wtek dystrybucji zdarze
 * maj uzyskuj dostp do tej listy.
 */
class BadWorkerRunnable implements Runnable
{
   public BadWorkerRunnable(JComboBox aCombo)
   {
      combo = aCombo;
      generator = new Random();
   }

   public void run()
   {
      try
      {
         while (true)
         {
            int i = Math.abs(generator.nextInt());
            if (i % 2 == 0) combo.insertItemAt(i, 0);
            else if (combo.getItemCount() > 0) combo.removeItemAt(i % combo.getItemCount());
            Thread.sleep(1);
         }
      }
      catch (InterruptedException e)
      {
      }
   }

   private JComboBox combo;
   private Random generator;
}

/**
 * Niniejsza klasa modyfikuje list rozwijaln dodajc do niej i usuwajc z niej losowe liczby. Aby unikn
 * uszkodzenia tej listy, operacje edycji s przesyane do wtku dystrybucji zdarze.
 */
class GoodWorkerRunnable implements Runnable
{
   public GoodWorkerRunnable(JComboBox aCombo)
   {
      combo = aCombo;
      generator = new Random();
   }

   public void run()
   {
      try
      {
         while (true)
         {
            EventQueue.invokeLater(new Runnable()
               {
                  public void run()
                  {
                     int i = Math.abs(generator.nextInt());
                     if (i % 2 == 0) combo.insertItemAt(i, 0);
                     else if (combo.getItemCount() > 0) combo.removeItemAt(i
                           % combo.getItemCount());
                  }
               });
            Thread.sleep(1);
         }
      }
      catch (InterruptedException e)
      {
      }
   }

   private JComboBox combo;
   private Random generator;
}