import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * @version 1.33 2007-06-12
 * @author Cay Horstmann
 */
public class RadioButtonTest
{
   public static void main(String[] args)
   {
      EventQueue.invokeLater(new Runnable()
         {
            public void run()
            {
               RadioButtonFrame frame = new RadioButtonFrame();
               frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
               frame.setVisible(true);
            }
         });
   }
}

/**
 * Ramka z przykadow etykiet tekstow i przecznikami sucymi do wyboru rozmiaru czcionki.
 */
class RadioButtonFrame extends JFrame
{
   public RadioButtonFrame()
   {
      setTitle("RadioButtonTest");
      setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);

      // Dodanie przykadowej etykiety tekstowej.

      label = new JLabel("Ko i w grali w koci z pikn m u rda.");
      label.setFont(new Font("Serif", Font.PLAIN, DEFAULT_SIZE));
      add(label, BorderLayout.CENTER);

      // Dodanie przecznikw.

      buttonPanel = new JPanel();
      group = new ButtonGroup();

      addRadioButton("Maa", 8);
      addRadioButton("rednia", 12);
      addRadioButton("Dua", 18);
      addRadioButton("Bardzo dua", 36);

      add(buttonPanel, BorderLayout.SOUTH);
   }

   /**
    * Tworzy przecznik ustawiajcy rozmiar czcionki przykadowego tekstu.
    * @param name acuch identyfikujcy przecznik
    * @param size rozmiar czcionki ustawiany przez ten przecznik
    */
   public void addRadioButton(String name, final int size)
   {
      boolean selected = size == DEFAULT_SIZE;
      JRadioButton button = new JRadioButton(name, selected);
      group.add(button);
      buttonPanel.add(button);

      // Niniejszy suchacz ustawia rozmiar czcionki etykiety.

      ActionListener listener = new ActionListener()
         {
            public void actionPerformed(ActionEvent event)
            {
               // Parametr size odwouje si do ostatniego parametru metody addRadioButton.
               label.setFont(new Font("Serif", Font.PLAIN, size));
            }
         };

      button.addActionListener(listener);
   }

   public static final int DEFAULT_WIDTH = 400;
   public static final int DEFAULT_HEIGHT = 200;

   private JPanel buttonPanel;
   private ButtonGroup group;
   private JLabel label;

   private static final int DEFAULT_SIZE = 12;
}
