import java.awt.EventQueue;
import java.awt.event.*;
import javax.swing.*;

/**
 * @version 1.23 2007-05-30
 * @author Cay Horstmann
 */
public class MenuTest
{
   public static void main(String[] args)
   {
      EventQueue.invokeLater(new Runnable()
         {
            public void run()
            {
               MenuFrame frame = new MenuFrame();
               frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
               frame.setVisible(true);
            }
         });
   }
}

/**
 * Ramka z paskiem menu.
 */
class MenuFrame extends JFrame
{
   public MenuFrame()
   {
      setTitle("MenuTest");
      setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);

      JMenu fileMenu = new JMenu("Plik");
      fileMenu.add(new TestAction("Nowy"));

      // Akceleratory

      JMenuItem openItem = fileMenu.add(new TestAction("Otwrz"));
      openItem.setAccelerator(KeyStroke.getKeyStroke("ctrl O"));

      fileMenu.addSeparator();

      saveAction = new TestAction("Zapisz");
      JMenuItem saveItem = fileMenu.add(saveAction);
      saveItem.setAccelerator(KeyStroke.getKeyStroke("ctrl S"));

      saveAsAction = new TestAction("Zapisz jako");
      fileMenu.add(saveAsAction);
      fileMenu.addSeparator();

      fileMenu.add(new AbstractAction("Zakocz")
         {
            public void actionPerformed(ActionEvent event)
            {
               System.exit(0);
            }
         });

      // Menu z polem wyboru i przecznikami

      readonlyItem = new JCheckBoxMenuItem("Tylko do odczytu");
      readonlyItem.addActionListener(new ActionListener()
         {
            public void actionPerformed(ActionEvent event)
            {
               boolean saveOk = !readonlyItem.isSelected();
               saveAction.setEnabled(saveOk);
               saveAsAction.setEnabled(saveOk);
            }
         });

      ButtonGroup group = new ButtonGroup();

      JRadioButtonMenuItem insertItem = new JRadioButtonMenuItem("Wstawianie");
      insertItem.setSelected(true);
      JRadioButtonMenuItem overtypeItem = new JRadioButtonMenuItem("Nadpisywanie");

      group.add(insertItem);
      group.add(overtypeItem);

      // Ikony

      Action cutAction = new TestAction("Wytnij");
      cutAction.putValue(Action.SMALL_ICON, new ImageIcon("cut.gif"));
      Action copyAction = new TestAction("Kopiuj");
      copyAction.putValue(Action.SMALL_ICON, new ImageIcon("copy.gif"));
      Action pasteAction = new TestAction("Wklej");
      pasteAction.putValue(Action.SMALL_ICON, new ImageIcon("paste.gif"));

      JMenu editMenu = new JMenu("Edycja");
      editMenu.add(cutAction);
      editMenu.add(copyAction);
      editMenu.add(pasteAction);

      // Zagniedone menu

      JMenu optionMenu = new JMenu("Opcje");

      optionMenu.add(readonlyItem);
      optionMenu.addSeparator();
      optionMenu.add(insertItem);
      optionMenu.add(overtypeItem);

      editMenu.addSeparator();
      editMenu.add(optionMenu);

      // Mnemoniki

      JMenu helpMenu = new JMenu("Pomoc");
      helpMenu.setMnemonic('P');

      JMenuItem indexItem = new JMenuItem("Indeks");
      indexItem.setMnemonic('I');
      helpMenu.add(indexItem);

      // Mnemoniki mona take dodawa do akcji.
      Action aboutAction = new TestAction("O programie");
      aboutAction.putValue(Action.MNEMONIC_KEY, new Integer('O'));
      helpMenu.add(aboutAction);

      // Dodanie wszystkich menu najwyszego rzdu do paska menu.

      JMenuBar menuBar = new JMenuBar();
      setJMenuBar(menuBar);

      menuBar.add(fileMenu);
      menuBar.add(editMenu);
      menuBar.add(helpMenu);

      // Menu kontekstowe

      popup = new JPopupMenu();
      popup.add(cutAction);
      popup.add(copyAction);
      popup.add(pasteAction);

      JPanel panel = new JPanel();
      panel.setComponentPopupMenu(popup);
      add(panel);

      // Poniszy wiersz obchodzi bd 4966109.
      panel.addMouseListener(new MouseAdapter()
         {
         });
   }

   public static final int DEFAULT_WIDTH = 300;
   public static final int DEFAULT_HEIGHT = 200;

   private Action saveAction;
   private Action saveAsAction;
   private JCheckBoxMenuItem readonlyItem;
   private JPopupMenu popup;
}

/**
 * Przykadowa akcja, ktra drukuje nazw akcji do wyjcia System.out.
 */
class TestAction extends AbstractAction
{
   public TestAction(String name)
   {
      super(name);
   }

   public void actionPerformed(ActionEvent event)
   {
      System.out.println(getValue(Action.NAME) + " selected.");
   }
}
