import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * @version 1.33 2007-06-12
 * @author Cay Horstmann
 */
public class DataExchangeTest
{
   public static void main(String[] args)
   {
      EventQueue.invokeLater(new Runnable()
         {
            public void run()
            {
               DataExchangeFrame frame = new DataExchangeFrame();
               frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
               frame.setVisible(true);
            }
         });
   }
}

/**
 * Ramka z menu, ktrego akcja Plik->Pocz wywietla okno dialogowe z polem hasa.
 */
class DataExchangeFrame extends JFrame
{
   public DataExchangeFrame()
   {
      setTitle("DataExchangeTest");
      setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);

      // Tworzenie menu Plik

      JMenuBar mbar = new JMenuBar();
      setJMenuBar(mbar);
      JMenu fileMenu = new JMenu("Plik");
      mbar.add(fileMenu);

      // Tworzenie elementw menu Pocz i Zamknij.

      JMenuItem connectItem = new JMenuItem("Pocz");
      connectItem.addActionListener(new ConnectAction());
      fileMenu.add(connectItem);

      // Opcja Zamknij zamyka program.

      JMenuItem exitItem = new JMenuItem("Zamknij");
      exitItem.addActionListener(new ActionListener()
         {
            public void actionPerformed(ActionEvent event)
            {
               System.exit(0);
            }
         });
      fileMenu.add(exitItem);

      textArea = new JTextArea();
      add(new JScrollPane(textArea), BorderLayout.CENTER);
   }

   public static final int DEFAULT_WIDTH = 300;
   public static final int DEFAULT_HEIGHT = 200;

   private PasswordChooser dialog = null;
   private JTextArea textArea;

   /**
    * Akcja Connect wywietla okno dialogowe z polem hasa.
    */

   private class ConnectAction implements ActionListener
   {
      public void actionPerformed(ActionEvent event)
      {
         // Jeli jest to pierwszy raz, tworzy okno dialogowe.

         if (dialog == null) dialog = new PasswordChooser();

         // Ustawianie wartoci domylnych
         dialog.setUser(new User("nazwauytkownika", null));

         // Wywietlanie okna dialogowego.
         if (dialog.showDialog(DataExchangeFrame.this, "Pocz"))
         {
            // Pobranie danych uytkownika w przypadku zatwierdzenia.
            User u = dialog.getUser();
            textArea.append("nazwa uytkownika = " + u.getName() + ", haso = "
                  + (new String(u.getPassword())) + "\n");
         }
      }
   }
}

/**
 * Elementy suce do podania hasa, ktre wida w oknie dialogowym.
 */
class PasswordChooser extends JPanel
{
   public PasswordChooser()
   {
      setLayout(new BorderLayout());

      // Tworzenie panelu z polami nazwy uytkownika i hasa.

      JPanel panel = new JPanel();
      panel.setLayout(new GridLayout(2, 2));
      panel.add(new JLabel("Nazwa uytkownika:"));
      panel.add(username = new JTextField(""));
      panel.add(new JLabel("Haso:"));
      panel.add(password = new JPasswordField(""));
      add(panel, BorderLayout.CENTER);

      // Tworzenie przyciskw Ok i Anuluj, ktre zamykaj okno dialogowe.

      okButton = new JButton("Ok");
      okButton.addActionListener(new ActionListener()
         {
            public void actionPerformed(ActionEvent event)
            {
               ok = true;
               dialog.setVisible(false);
            }
         });

      JButton cancelButton = new JButton("Anuluj");
      cancelButton.addActionListener(new ActionListener()
         {
            public void actionPerformed(ActionEvent event)
            {
               dialog.setVisible(false);
            }
         });

      // Dodawanie przyciskw w pobliu poudniowej krawdzi.

      JPanel buttonPanel = new JPanel();
      buttonPanel.add(okButton);
      buttonPanel.add(cancelButton);
      add(buttonPanel, BorderLayout.SOUTH);
   }

   /**
    * Ustawia wartoci domylne okna dialogowego.
    * @param u domylne informacje uytkownika
    */
   public void setUser(User u)
   {
      username.setText(u.getName());
   }

   /**
    * Pobiera dane podane w oknie dialogowym.
    * @return a obiekt typu User, ktrego stan reprezentuje dane wprowadzone w oknie dialogowym
    */
   public User getUser()
   {
      return new User(username.getText(), password.getPassword());
   }

   /**
    * Wywietla panel z elementami przyjmujcymi dane od uytkownika w oknie dialogowym.
    * @param parent komponent w ramce nadrzdnej lub warto null
    * @param title tytu okna dialogowego
    */
   public boolean showDialog(Component parent, String title)
   {
      ok = false;

      // Lokalizacja ramki nadrzdnej.

      Frame owner = null;
      if (parent instanceof Frame) owner = (Frame) parent;
      else owner = (Frame) SwingUtilities.getAncestorOfClass(Frame.class, parent);

      // Jeli jest to pierwszy raz lub zmieni si uytkownik, utworzenie nowego okna dialogowego.

      if (dialog == null || dialog.getOwner() != owner)
      {
         dialog = new JDialog(owner, true);
         dialog.add(this);
         dialog.getRootPane().setDefaultButton(okButton);
         dialog.pack();
      }

      // Ustawienie tytuu i wywietlenie okna dialogowego.

      dialog.setTitle(title);
      dialog.setVisible(true);
      return ok;
   }

   private JTextField username;
   private JPasswordField password;
   private JButton okButton;
   private boolean ok;
   private JDialog dialog;
}

/**
 * Uytkownik ma nazw i haso. Ze wzgldw bezpieczestwa haso jest przechowywane jako typ char[], a nie String.
 */
class User
{
   public User(String aName, char[] aPassword)
   {
      name = aName;
      password = aPassword;
   }

   public String getName()
   {
      return name;
   }

   public char[] getPassword()
   {
      return password;
   }

   public void setName(String aName)
   {
      name = aName;
   }

   public void setPassword(char[] aPassword)
   {
      password = aPassword;
   }

   private String name;
   private char[] password;
}
