import java.util.*;

/**
 * Niniejszy program demonstruje uycie mapy z kluczami typu String i wartociami typu Employee.
 * @version 1.10 2004-08-02
 * @author Cay Horstmann
 */
public class MapTest
{
   public static void main(String[] args)
   {
      Map<String, Employee> staff = new HashMap<String, Employee>();
      staff.put("144-25-5464", new Employee("Amy Lee"));
      staff.put("567-24-2546", new Employee("Harry Hacker"));
      staff.put("157-62-7935", new Employee("Gary Cooper"));
      staff.put("456-62-5527", new Employee("Francesca Cruz"));

      // wydruk wszystkich pozycji

      System.out.println(staff);

      // usunicie wartoci

      staff.remove("567-24-2546");

      // podmienienie pozycji

      staff.put("456-62-5527", new Employee("Francesca Miller"));

      // wyszukanie wartoci

      System.out.println(staff.get("157-62-7935"));

      // iteracja przez wszystkie pozycje

      for (Map.Entry<String, Employee> entry : staff.entrySet())
      {
         String key = entry.getKey();
         Employee value = entry.getValue();
         System.out.println("klucz=" + key + ", warto=" + value);
      }
   }
}

/**
 * Zminimalizowana klasa Employee do celw testowych.
 */
class Employee
{
   /**
    * Tworzy obiekt Employee z pensj w wysokoci 0.
    * @param n the employee name
    */
   public Employee(String n)
   {
      name = n;
      salary = 0;
   }

   public String toString()
   {
      return "[Imi i nazwisko=" + name + ", pensja=" + salary + "]";
   }

   private String name;
   private double salary;
}
