import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * Panel zawierajcy trzy przyciski.
 * @version 1.32 2004-05-11
 * @author Cay Horstmann
 */
class ButtonPanel extends JPanel
{
   public ButtonPanel()
   {
      // tworzenie przyciskw

      JButton yellowButton = new JButton("ty");
      JButton blueButton = new JButton("Niebieski");
      JButton redButton = new JButton("Czerwony");

      // dodanie przyciskw do panelu

      add(yellowButton);
      add(blueButton);
      add(redButton);

      // utworzenie akcji przyciskw

      ColorAction yellowAction = new ColorAction(Color.YELLOW);
      ColorAction blueAction = new ColorAction(Color.BLUE);
      ColorAction redAction = new ColorAction(Color.RED);

      // powizanie akcji z przyciskami

      yellowButton.addActionListener(yellowAction);
      blueButton.addActionListener(blueAction);
      redButton.addActionListener(redAction);
   }

   /**
    * Suchacz akcji ustawiajcy kolor ta panelu.
    */
   private class ColorAction implements ActionListener
   {
      public ColorAction(Color c)
      {
         backgroundColor = c;
      }

      public void actionPerformed(ActionEvent event)
      {
         setBackground(backgroundColor);
      }

      private Color backgroundColor;
   }
}
