import java.awt.*;

/**
 * Niniejsza klasa upraszcza korzystanie z klasy GridBagConstraints.
 * @version 1.01 2004-05-06
 * @author Cay Horstmann
 */
public class GBC extends GridBagConstraints
{
   /**
    * Tworzy obiekt typu GBC z podanymi wartociami gridx i gridy oraz wszystkimi pozostaymi
    * parametrami ustawionymi na wartoci domylne.
    * @param gridx wsprzdna gridx
    * @param gridy wsprzdna gridy
    */
   public GBC(int gridx, int gridy)
   {
      this.gridx = gridx;
      this.gridy = gridy;
   }

   /**
    * Tworzy obiekt typu GBC z podanymi wartociami gridx, gridy, gridwidth i gridheight oraz wszystkimi pozostaymi
    * parametrami ustawionymi na wartoci domylne.
    * @param gridx wsprzdna gridx
    * @param gridy wsprzdna gridy
    * @param gridwidth liczba zajmowanych komrek w poziomie
    * @param gridheight liczba zajmowanych komrek w pionie
    */
   public GBC(int gridx, int gridy, int gridwidth, int gridheight)
   {
      this.gridx = gridx;
      this.gridy = gridy;
      this.gridwidth = gridwidth;
      this.gridheight = gridheight;
   }

   /**
    * Ustawia parametr anchor.
    * @param anchor warto parametru anchor
    * @return this obiekt do dalszej modyfikacji
    */
   public GBC setAnchor(int anchor)
   {
      this.anchor = anchor;
      return this;
   }

   /**
    * Ustawia kierunek zapeniania.
    * @param fill kierunek zapeniania
    * @return this obiekt do dalszej modyfikacji
    */
   public GBC setFill(int fill)
   {
      this.fill = fill;
      return this;
   }

   /**
    * Ustawia parametry weigh komrek.
    * @param weightx parametr weigh w poziomie
    * @param weighty parametr weigh w pionie
    * @return this obiekt do dalszej modyfikacji
    */
   public GBC setWeight(double weightx, double weighty)
   {
      this.weightx = weightx;
      this.weighty = weighty;
      return this;
   }

   /**
    * Ustawia dodatkow pust przestrze w komrce.
    * @param distance dopenienie we wszystkich kierunkach
    * @return this obiekt do dalszej modyfikacji
    */
   public GBC setInsets(int distance)
   {
      this.insets = new Insets(distance, distance, distance, distance);
      return this;
   }

   /**
    * Ustawia dopenienia w komrce.
    * @param top odstp od krawdzi grnej
    * @param left odstp od krawdzi lewej
    * @param bottom odstp od krawdzi dolnej
    * @param right odstp od krawdzi prawej
    * @return obiekt do dalszej modyfikacji
    */
   public GBC setInsets(int top, int left, int bottom, int right)
   {
      this.insets = new Insets(top, left, bottom, right);
      return this;
   }

   /**
    * Ustawia dopenienie wewntrzne.
    * @param ipadx dopenienie wewntrzne poziome
    * @param ipady dopenienie wewntrzne pionowe
    * @return obiekt do dalszej modyfikacji
    */
   public GBC setIpad(int ipadx, int ipady)
   {
      this.ipadx = ipadx;
      this.ipady = ipady;
      return this;
   }
}
