import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * @version 1.33 2007-06-12
 * @author Cay Horstmann
 */
public class CheckBoxTest
{
   public static void main(String[] args)
   {
      EventQueue.invokeLater(new Runnable()
         {
            public void run()
            {
               CheckBoxFrame frame = new CheckBoxFrame();
               frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
               frame.setVisible(true);
            }
         });
   }
}

/**
 * Ramka z przykadow etykiet tekstow i polami wyboru atrybutw czcionki.
 */
class CheckBoxFrame extends JFrame
{
   public CheckBoxFrame()
   {
      setTitle("CheckBoxTest");
      setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);

      // Dodanie przykadowej etykiety tekstowej.

      label = new JLabel("Ko i w grali w koci z pikn m u rda.");
      label.setFont(new Font("Serif", Font.PLAIN, FONTSIZE));
      add(label, BorderLayout.CENTER);

      // Niniejszy suchacz ustawia atrybut czcionki
      // etykiety na taki, jaki wybrano w polu wyboru.

      ActionListener listener = new ActionListener()
         {
            public void actionPerformed(ActionEvent event)
            {
               int mode = 0;
               if (bold.isSelected()) mode += Font.BOLD;
               if (italic.isSelected()) mode += Font.ITALIC;
               label.setFont(new Font("Serif", mode, FONTSIZE));
            }
         };

      // Dodanie pl wyboru.

      JPanel buttonPanel = new JPanel();

      bold = new JCheckBox("Pogrubienie");
      bold.addActionListener(listener);
      buttonPanel.add(bold);

      italic = new JCheckBox("Kursywa");
      italic.addActionListener(listener);
      buttonPanel.add(italic);

      add(buttonPanel, BorderLayout.SOUTH);
   }

   public static final int DEFAULT_WIDTH = 300;
   public static final int DEFAULT_HEIGHT = 200;

   private JLabel label;
   private JCheckBox bold;
   private JCheckBox italic;

   private static final int FONTSIZE = 12;
}
