import java.lang.reflect.*;
import java.util.*;

/**
 * Niniejszy program demonstruje uycie klas poredniczcych.
 * @version 1.00 2000-04-13
 * @author Cay Horstmann
 */
public class ProxyTest
{
   public static void main(String[] args)
   {
      Object[] elements = new Object[1000];

      // Wstawienie do tablicy obiektw porednich liczb cakowitych z przedziau 1-1000.
      for (int i = 0; i < elements.length; i++)
      {
         Integer value = i + 1;
         InvocationHandler handler = new TraceHandler(value);
         Object proxy = Proxy.newProxyInstance(null, new Class[] { Comparable.class } , handler);
         elements[i] = proxy;
      }

      // Tworzenie losowej liczby cakowitej.
      Integer key = new Random().nextInt(elements.length) + 1;

      // Szukanie liczby.
      int result = Arrays.binarySearch(elements, key);

      // Drukowanie dopasowanej wartoci, jeli zostanie znaleziona.
      if (result >= 0) System.out.println(elements[result]);
   }
}

/**
 * Obiekt obsugujcy wywoanie, ktry drukuje nazw metody i parametry, a nastpnie
 * wywouje oryginaln metod.
 */
class TraceHandler implements InvocationHandler
{
   /**
    * Tworzy obiekt TraceHandler.
    * @param t parametr niejawny wywoania metody
    */
   public TraceHandler(Object t)
   {
      target = t;
   }

   public Object invoke(Object proxy, Method m, Object[] args) throws Throwable
   {
      // Drukowanie argumentu niejawnego.
      System.out.print(target);
      // Drukowanie nazwy metody.
      System.out.print("." + m.getName() + "(");
      // Drukowanie argumentw jawnych.
      if (args != null)
      {
         for (int i = 0; i < args.length; i++)
         {
            System.out.print(args[i]);
            if (i < args.length - 1) System.out.print(", ");
         }
      }
      System.out.println(")");

      // Wywoanie rzeczywistej metody.
      return m.invoke(target, args);
   }

   private Object target;
}
