/**
 * Klasa implementujca interfejs Runnable, ktra przelewa pienidze z jednego konta na inne konta w banku.
 * @version 1.30 2004-08-01
 * @author Cay Horstmann
 */
public class TransferRunnable implements Runnable
{
   /**
    * tworzy obiekt klasy TransferRunnable.
    * @param b bank, ktrego pienidze na kontach maj zosta przelane
    * @param from konto, z ktrego maj by pobrane pienidze
    * @param max maksymalna kwota pojedynczego przelewu
    */
   public TransferRunnable(Bank b, int from, double max)
   {
      bank = b;
      fromAccount = from;
      maxAmount = max;
   }

   public void run()
   {
      try
      {
         while (true)
         {
            int toAccount = (int) (bank.size() * Math.random());
            double amount = maxAmount * Math.random();
            bank.transfer(fromAccount, toAccount, amount);
            Thread.sleep((int) (DELAY * Math.random()));
         }
      }
      catch (InterruptedException e)
      {
      }
   }

   private Bank bank;
   private int fromAccount;
   private double maxAmount;
   private int DELAY = 10;
}