import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import javax.swing.*;
import javax.swing.filechooser.*;
import javax.swing.filechooser.FileFilter;

/**
 * @version 1.23 2007-06-12
 * @author Cay Horstmann
 */
public class FileChooserTest
{
   public static void main(String[] args)
   {
      EventQueue.invokeLater(new Runnable()
         {
            public void run()
            {
               ImageViewerFrame frame = new ImageViewerFrame();
               frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
               frame.setVisible(true);
            }
         });
   }
}

/**
 * Ramka z menu zawierajcym opcj Otwrz i obszarem do prezentacji otwartych obrazw.
 */
class ImageViewerFrame extends JFrame
{
   public ImageViewerFrame()
   {
      setTitle("FileChooserTest");
      setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);

      // pasek menu
      JMenuBar menuBar = new JMenuBar();
      setJMenuBar(menuBar);

      JMenu menu = new JMenu("Plik");
      menuBar.add(menu);

      JMenuItem openItem = new JMenuItem("Otwrz");
      menu.add(openItem);
      openItem.addActionListener(new FileOpenListener());

      JMenuItem exitItem = new JMenuItem("Zamknij");
      menu.add(exitItem);
      exitItem.addActionListener(new ActionListener()
         {
            public void actionPerformed(ActionEvent event)
            {
               System.exit(0);
            }
         });

      // Etykieta do wywietlania obrazw.
      label = new JLabel();
      add(label);

      // okno wyboru plikw
      chooser = new JFileChooser();

      // akceptuje wszystkie pliki obrazw z rozszerzeniem .jpg, .jpeg, .gif
      /*
      final ExtensionFileFilter filter = new ExtensionFileFilter();
      filter.addExtension("jpg");
      filter.addExtension("jpeg");
      filter.addExtension("gif");
      filter.setDescription("Pliki obrazw");
      */
      FileNameExtensionFilter filter = new FileNameExtensionFilter("Pliki obrazw", "jpg", "jpeg", "gif");
      chooser.setFileFilter(filter);

      chooser.setAccessory(new ImagePreviewer(chooser));

      chooser.setFileView(new FileIconView(filter, new ImageIcon("palette.gif")));
   }

   /**
    * Suchacz elementu menu Plik->Otwrz.
    */
   private class FileOpenListener implements ActionListener
   {
      public void actionPerformed(ActionEvent event)
      {
         chooser.setCurrentDirectory(new File("."));

         // Wywietlanie okna dialogowego wyboru plikw.
         int result = chooser.showOpenDialog(ImageViewerFrame.this);

         // Jeli plik obrazu jest zaakceptowany, ustawienie go jako ikon etykiety.
         if (result == JFileChooser.APPROVE_OPTION)
         {
            String name = chooser.getSelectedFile().getPath();
            label.setIcon(new ImageIcon(name));
         }
      }
   }

   public static final int DEFAULT_WIDTH = 300;
   public static final int DEFAULT_HEIGHT = 400;

   private JLabel label;
   private JFileChooser chooser;
}

/**
 * Widok plikw wywietlajcy ikon obok wszystkich plikw zaakceptowanych przez filtr.
 */
class FileIconView extends FileView
{
   /**
    * Tworzy obiekt FileIconView.
    * @param aFilter filtr plikw - wszstkie pliki zaakceptowane przez ten filtr bd miay ikon.
    * @param anIcon - ikona wywietlana obok wszystkich zaakceptowanych plikw.
    */
   public FileIconView(FileFilter aFilter, Icon anIcon)
   {
      filter = aFilter;
      icon = anIcon;
   }

   public Icon getIcon(File f)
   {
      if (!f.isDirectory() && filter.accept(f)) return icon;
      else return null;
   }

   private FileFilter filter;
   private Icon icon;
}

/**
 * Akcesorium wywietlajce podgld obrazw.
 */
class ImagePreviewer extends JLabel
{
   /**
    * Tworzy obiekt ImagePreviewer.
    * @param chooser okno wyboru plikw, ktrego wasno zmienia si powoduje zmian obrazu w tym podgldzie.
    */
   public ImagePreviewer(JFileChooser chooser)
   {
      setPreferredSize(new Dimension(100, 100));
      setBorder(BorderFactory.createEtchedBorder());

      chooser.addPropertyChangeListener(new PropertyChangeListener()
         {
            public void propertyChange(PropertyChangeEvent event)
            {
               if (event.getPropertyName() == JFileChooser.SELECTED_FILE_CHANGED_PROPERTY)
               {
                  // Uytkownik wybra inny plik.
                  File f = (File) event.getNewValue();
                  if (f == null)
                  {
                     setIcon(null);
                     return;
                  }

                  // Wczytanie obrazu jako ikony.
                  ImageIcon icon = new ImageIcon(f.getPath());

                  // Skalowanie obrazu, jeli jest zbyt duy na ikon.
                  if (icon.getIconWidth() > getWidth()) icon = new ImageIcon(icon.getImage()
                        .getScaledInstance(getWidth(), -1, Image.SCALE_DEFAULT));

                  setIcon(icon);
               }
            }
         });
   }
}
