import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.Timer;

/**
 * Niniejszy program demonstruje zastosowanie anonimowych klas wewntrznych.
 * @version 1.10 2004-02-27
 * @author Cay Horstmann
 */
public class AnonymousInnerClassTest
{
   public static void main(String[] args)
   {
      TalkingClock clock = new TalkingClock();
      clock.start(1000, true);

      // Niech program dziaa dopki uytkownik nie wcinie przycisku Ok.
      JOptionPane.showMessageDialog(null, "Quit program?");
      System.exit(0);
   }
}

/**
 * Zegar drukujcy informacje o czasie w rwnych odstpach czasu.
 */
class TalkingClock
{
   /**
    * Tworzy obiekt TalkingClock.
    * @param interval odstp czasu pomidzy kolejnymi komunikatami (w milisekundach)
    * @param beep warto true oznacza, e dwik ma by odtwarzany
    */
   public void start(int interval, final boolean beep)
   {
      ActionListener listener = new ActionListener()
         {
            public void actionPerformed(ActionEvent event)
            {
               Date now = new Date();
               System.out.println("Kiedy usyszysz dwik bdzie godzina " + now);
               if (beep) Toolkit.getDefaultToolkit().beep();
            }
         };
      Timer t = new Timer(interval, listener);
      t.start();
   }
}
