import java.util.*;

/**
 * Niniejszy program demonstruje dziedziczenie.
 * @version 1.21 2004-02-21
 * @author Cay Horstmann
 */
public class ManagerTest
{
   public static void main(String[] args)
   {
      // Tworzenie obiektu klasy Manager.
      Manager boss = new Manager("Karol Parol", 80000, 1987, 12, 15);
      boss.setBonus(5000);

      Employee[] staff = new Employee[3];

      // Wstawienie obiektw klas Manager i Employee do tablicy staff.

      staff[0] = boss;
      staff[1] = new Employee("Henryk Kwiatek", 50000, 1989, 10, 1);
      staff[2] = new Employee("Artur Kwiatkowski", 40000, 1990, 3, 15);

      // Drukowanie informacji o wszystkich obiektach klasy Employee.
      for (Employee e : staff)
         System.out.println("name=" + e.getName() + ",salary=" + e.getSalary());
   }
}

class Employee
{
   public Employee(String n, double s, int year, int month, int day)
   {
      name = n;
      salary = s;
      GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day);
      hireDay = calendar.getTime();
   }

   public String getName()
   {
      return name;
   }

   public double getSalary()
   {
      return salary;
   }

   public Date getHireDay()
   {
      return hireDay;
   }

   public void raiseSalary(double byPercent)
   {
      double raise = salary * byPercent / 100;
      salary += raise;
   }

   private String name;
   private double salary;
   private Date hireDay;
}

class Manager extends Employee
{
   /**
    * @param n nazwa pracownika
    * @param s pensja
    * @param year rok przyjcia do pracy
    * @param month miesic przyjcia do pracy
    * @param day dzie przyjcia do pracy
    */
   public Manager(String n, double s, int year, int month, int day)
   {
      super(n, s, year, month, day);
      bonus = 0;
   }

   public double getSalary()
   {
      double baseSalary = super.getSalary();
      return baseSalary + bonus;
   }

   public void setBonus(double b)
   {
      bonus = b;
   }

   private double bonus;
}
