import java.lang.reflect.*;

/**
 * Niniejszy program demonstruje zastosowanie refleksji do manipulacji tablicami.
 * @version 1.01 2004-02-21
 * @author Cay Horstmann
 */
public class ArrayGrowTest
{
   public static void main(String[] args)
   {
      int[] a = { 1, 2, 3 };
      a = (int[]) goodArrayGrow(a);
      arrayPrint(a);

      String[] b = { "Tom", "Dick", "Harry" };
      b = (String[]) goodArrayGrow(b);
      arrayPrint(b);

      System.out.println("Ponisze wywoanie spowoduje wyjtek.");
      b = (String[]) badArrayGrow(b);
   }

   /**
    * Niniejsza metoda prbuje powikszy tablic tworzc now tablic i kopiujc wszystkie elementy.
    * @param a tablica, ktra ma by powikszona
    * @return wiksza tablica zawierajca wszystkie elementy tablicy a. Ale zwrcona tablica jest 
    * typu Object[], a nie takiego samego jak a.
    */
   static Object[] badArrayGrow(Object[] a)
   {
      int newLength = a.length * 11 / 10 + 10;
      Object[] newArray = new Object[newLength];
      System.arraycopy(a, 0, newArray, 0, a.length);
      return newArray;
   }

   /**
    * Niniejsza metoda powiksza tablic tworzc now tablic tego samego typu i
    * kopiujc wszystkie elementy.
    * @param a tablica, ktra ma by powikszona. Moe to by tablica obiektw lub
    * elementw typu podstawowego.
    * @return wiksza tablica zawierajca wszystkie elementy tablicy a.
    */
   static Object goodArrayGrow(Object a)
   {
      Class cl = a.getClass();
      if (!cl.isArray()) return null;
      Class componentType = cl.getComponentType();
      int length = Array.getLength(a);
      int newLength = length * 11 / 10 + 10;

      Object newArray = Array.newInstance(componentType, newLength);
      System.arraycopy(a, 0, newArray, 0, length);
      return newArray;
   }

   /**
    * Metdoa drukujca wszystkie elementy tablicy
    * @param a tablica do wydrukowania. Moe to by tablica obiektw lub
    * elementw typu podstawowego.
    */
   static void arrayPrint(Object a)
   {
      Class cl = a.getClass();
      if (!cl.isArray()) return;
      Class componentType = cl.getComponentType();
      int length = Array.getLength(a);
      System.out.print(componentType.getName() + "[" + length + "] = { ");
      for (int i = 0; i < Array.getLength(a); i++)
         System.out.print(Array.get(a, i) + " ");
      System.out.println("}");
   }
}
