package com.horstmann.corejava;

// Klasy znajdujce si w tym pliku nale do powyszego pakietu.

import java.util.*;

// Instrukcje import nastpuj po instrukcji package.

/**
 * @version 1.10 1999-12-18
 * @author Cay Horstmann
 */
public class Employee
{
   public Employee(String n, double s, int year, int month, int day)
   {
      name = n;
      salary = s;
      GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day);
      // W klasie GregorianCalendar stycze ma numer 0.
      hireDay = calendar.getTime();
   }

   public String getName()
   {
      return name;
   }

   public double getSalary()
   {
      return salary;
   }

   public Date getHireDay()
   {
      return hireDay;
   }

   public void raiseSalary(double byPercent)
   {
      double raise = salary * byPercent / 100;
      salary += raise;
   }

   private String name;
   private double salary;
   private Date hireDay;
}
