/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;

public class CalculatorPanel
extends JPanel {
    private JTextArea display;
    private JPanel panel;
    private double result;
    private String lastCommand;
    private boolean start;

    public CalculatorPanel() {
        this.setLayout(new BorderLayout());
        this.result = 0.0;
        this.lastCommand = "=";
        this.start = true;
        this.display = new JTextArea(10, 20);
        this.add((Component)new JScrollPane(this.display), "North");
        InsertAction insert = new InsertAction();
        CommandAction command = new CommandAction();
        this.panel = new JPanel();
        this.panel.setLayout(new GridLayout(4, 4));
        this.addButton("7", insert);
        this.addButton("8", insert);
        this.addButton("9", insert);
        this.addButton("/", command);
        this.addButton("4", insert);
        this.addButton("5", insert);
        this.addButton("6", insert);
        this.addButton("*", command);
        this.addButton("1", insert);
        this.addButton("2", insert);
        this.addButton("3", insert);
        this.addButton("-", command);
        this.addButton("0", insert);
        this.addButton(".", insert);
        this.addButton("=", command);
        this.addButton("+", command);
        this.add((Component)this.panel, "Center");
    }

    public String getText() {
        return this.display.getText();
    }

    public void append(String s) {
        this.display.append(s);
    }

    private void addButton(String label, ActionListener listener) {
        JButton button = new JButton(label);
        button.addActionListener(listener);
        this.panel.add(button);
    }

    public void calculate(double x) {
        if (this.lastCommand.equals("+")) {
            this.result += x;
        } else if (this.lastCommand.equals("-")) {
            this.result -= x;
        } else if (this.lastCommand.equals("*")) {
            this.result *= x;
        } else if (this.lastCommand.equals("/")) {
            this.result /= x;
        } else if (this.lastCommand.equals("=")) {
            this.result = x;
        }
    }

    private class CommandAction
    implements ActionListener {
        private CommandAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (CalculatorPanel.this.start) {
                if (command.equals("-")) {
                    CalculatorPanel.this.display.append(command);
                    CalculatorPanel.this.start = false;
                } else {
                    CalculatorPanel.this.lastCommand = command;
                }
            } else {
                try {
                    int lines = CalculatorPanel.this.display.getLineCount();
                    int lineStart = CalculatorPanel.this.display.getLineStartOffset(lines - 1);
                    int lineEnd = CalculatorPanel.this.display.getLineEndOffset(lines - 1);
                    String value = CalculatorPanel.this.display.getText(lineStart, lineEnd - lineStart);
                    CalculatorPanel.this.display.append(" ");
                    CalculatorPanel.this.display.append(command);
                    CalculatorPanel.this.calculate(Double.parseDouble(value));
                    if (command.equals("=")) {
                        CalculatorPanel.this.display.append("\n" + CalculatorPanel.this.result);
                    }
                    CalculatorPanel.this.lastCommand = command;
                    CalculatorPanel.this.display.append("\n");
                    CalculatorPanel.this.start = true;
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class InsertAction
    implements ActionListener {
        private InsertAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String input = event.getActionCommand();
            CalculatorPanel.this.start = false;
            CalculatorPanel.this.display.append(input);
        }
    }
}

