/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.jnlp.BasicService;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.PersistenceService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

class CalculatorFrame
extends JFrame {
    private CalculatorPanel panel;

    public CalculatorFrame() {
        this.setTitle();
        this.panel = new CalculatorPanel();
        this.add(this.panel);
        JMenu fileMenu = new JMenu("Plik");
        JMenuItem openItem = fileMenu.add("Otw\u00f3rz");
        openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CalculatorFrame.this.open();
            }
        });
        JMenuItem saveItem = fileMenu.add("Zapisz");
        saveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CalculatorFrame.this.save();
            }
        });
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        this.setJMenuBar(menuBar);
        this.pack();
    }

    public void setTitle() {
        try {
            String title = null;
            BasicService basic = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            URL codeBase = basic.getCodeBase();
            PersistenceService service = (PersistenceService)ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
            URL key = new URL(codeBase, "title");
            try {
                FileContents contents = service.get(key);
                InputStream in = contents.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                title = reader.readLine();
            }
            catch (FileNotFoundException e) {
                title = JOptionPane.showInputDialog("Podaj tytu\u0142 dla ramki:");
                if (title == null) {
                    return;
                }
                service.create(key, 100L);
                FileContents contents = service.get(key);
                OutputStream out = contents.getOutputStream(true);
                PrintStream printOut = new PrintStream(out);
                printOut.print(title);
            }
            this.setTitle(title);
        }
        catch (UnavailableServiceException e) {
            JOptionPane.showMessageDialog(this, (Object)e);
        }
        catch (MalformedURLException e) {
            JOptionPane.showMessageDialog(this, e);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e);
        }
    }

    public void open() {
        try {
            FileOpenService service = (FileOpenService)ServiceManager.lookup((String)"javax.jnlp.FileOpenService");
            FileContents contents = service.openFileDialog(".", new String[]{"txt"});
            JOptionPane.showMessageDialog(this, contents.getName());
            if (contents != null) {
                String line;
                InputStream in = contents.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                while ((line = reader.readLine()) != null) {
                    this.panel.append(line);
                    this.panel.append("\n");
                }
            }
        }
        catch (UnavailableServiceException e) {
            JOptionPane.showMessageDialog(this, (Object)e);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e);
        }
    }

    public void save() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream printOut = new PrintStream(out);
            printOut.print(this.panel.getText());
            ByteArrayInputStream data = new ByteArrayInputStream(out.toByteArray());
            FileSaveService service = (FileSaveService)ServiceManager.lookup((String)"javax.jnlp.FileSaveService");
            service.saveFileDialog(".", new String[]{"txt"}, (InputStream)data, "calc.txt");
        }
        catch (UnavailableServiceException e) {
            JOptionPane.showMessageDialog(this, (Object)e);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e);
        }
    }
}

