package staticInnerClass;

/**
 * Ten program demonstruje zastosowanie statycznych klas wewntrznych.
 * @version 1.1 2023-12-19
 * @author Cay Horstmann
 */
public class StaticInnerClassTest
{
   public static void main(String[] args)
   {      
      double[] numbers = { 1, 2, 2, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6 };
      ArrayAlg.Range r = ArrayAlg.longestRun(numbers);
      System.out.println("od = " + r.getFrom());
      System.out.println("do = " + r.getTo());
   }
}

class ArrayAlg
{
   /**
    * Zakres wartoci indeksu.
    */
   public static class Range 
   {
      private int from;
      private int to;
      
      /**
       * Tworzy zakres o dugoci 1.
       * @param from the initial index value of this range
       */
      public Range(int from) 
      {
         this.from = from;
         this.to = from + 1;
      }
      
      /**
       * Rozszerza ten zakres o jeden element.
       */
      public void extend() 
      {
         this.to++;
      }
      
      /**
       * Pobiera warto indeksu pocztkowego tego zakresu.
       * @return the starting index
       */
      public int getFrom()
      {
         return from;
      }
      
      /**
       * Pobiera pierwszy indeks za kocem tego zakresu. 
       * @return the past-the-end index
       */
      public int getTo()
      {
         return to;
      }
      
      /**
       * Zwraca liczb elementw w tym zakresie.
       * @return the number of elements
       */
      public int length() 
      {
         return to - from;
      }
   }

   /**
    * Szereg to sekwencja takich samych elementw obok siebie. Na przykad
    * w tablicy 1 2 3 3 3 4 4 szeregi to 1 i 2 oraz 3 3 3 3 i 4 4.   
    * Zwraca zakres najduszego szeregu.
    * @param tablica o dugoci przynajmniej 1 
    * @return zakres najduszego szeregu
    */
   public static Range longestRun(double[] values)
   {
      Range longest = new Range(0);
      Range current = new Range(0);
      for (int i = 1; i < values.length; i++) 
      {
         if (values[i] == values[i - 1]) current.extend();
         else 
         {
            if (longest.length() < current.length()) longest = current;
            current = new Range(i);
         }
      }
      if (longest.length() < current.length()) longest = current;
      return longest;      
   }      
}