import java.awt.*;
import java.io.*;
import javax.swing.*;

/**
 * Program do przeglądania obrazów.
 * @version 1.31 2018-04-10
 * @author Cay Horstmann
 */
public class ImageViewer
{
   public static void main(String[] args)
   {
      EventQueue.invokeLater(() -> {
         var frame = new ImageViewerFrame();
         frame.setTitle("ImageViewer");
         frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
         frame.setVisible(true);
      });
   }
}

/**
 * Ramka z etykietą wyświetlająca obraz.
 */
class ImageViewerFrame extends JFrame
{
   private static final int DEFAULT_WIDTH = 300;
   private static final int DEFAULT_HEIGHT = 400;

   public ImageViewerFrame()
   {
      setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);

      // Użycie etykiety do wyświetlenia obrazów.
      var label = new JLabel();
      add(label);

      // Dodawanie opcji wyboru obrazu.
      var chooser = new JFileChooser();
      chooser.setCurrentDirectory(new File("."));

      // Pasek menu.
      var menuBar = new JMenuBar();
      setJMenuBar(menuBar);

      var menu = new JMenu("Plik");
      menuBar.add(menu);

      var openItem = new JMenuItem("Otwórz");
      menu.add(openItem);
      openItem.addActionListener(event -> {
         // Wyświetlenie okna dialogowego wyboru pliku.
         int result = chooser.showOpenDialog(null);

         // Jeśli plik został wybrany, ustawiamy go jako ikonę etykiety.
         if (result == JFileChooser.APPROVE_OPTION)
         {
            String name = chooser.getSelectedFile().getPath();
            label.setIcon(new ImageIcon(name));
         }
      });

      var exitItem = new JMenuItem("Zamknij");
      menu.add(exitItem);
      exitItem.addActionListener(event -> System.exit(0));
   }
}
