/**
* Ten program demonstruje zastosowanie rekordów.
* @version 1.0 2021-05-13
* @author Cay Horstmann
*/
public class RecordTest
{
    public static void main(String[] args)
    {
        var p = new Point(3, 4);
        System.out.println("Współrzędne punktu p: " + p.x() + " " + p.y());
        System.out.println("Odległość od środka: " + p.distanceFromOrigin());
        // Takie same obliczenia z polem statycznym i metodą statyczną
        System.out.println("Odległość od środka: " + Point.distance(Point.ORIGIN, p));

        // Zmienny rekord
        var pt = new PointInTime(3, 4, new Date());
        System.out.println("Przed: " + pt);
        pt.when().setTime(0);
        System.out.println("Po: " + pt);

        // Wywołanie konstruktora kompaktowego

        var r = new Range(4, 3);
        System.out.println("r: " + r);
    }
}

record Point(double x, double y)
{
    // Konstruktor niestandardowy
    public Point() { this(0, 0); }
    // Metoda
    public double distanceFromOrigin()
    {
        return Math.hypot(x, y);
    }
    // Statyczne pole i metoda
    public static Point ORIGIN = new Point();
    public static double distance(Point p, Point q)
    {
        return Math.hypot(p.x - q.x, p.y - q.y);
    }
}

record PointInTime(double x, double y, Date when) { }

record Range(int from, int to)
{
    // Kompaktowy konstruktor
    public Range
    {
        if (from > to) // Zamiana granic
        {
            int temp = from;
            from = to;
            to = temp;
        }
    }
}