// Prezentacja pól wyboru.  
 
import javafx.application.*; 
import javafx.scene.*; 
import javafx.stage.*; 
import javafx.scene.layout.*; 
import javafx.scene.control.*; 
import javafx.event.*; 
import javafx.geometry.*; 
 
public class CheckboxDemo extends Application { 
 
  CheckBox cbWeb; 
  CheckBox cbDesktop; 
  CheckBox cbMobile; 
 
  Label response; 
  Label allTargets; 
 
  String targets = ""; 
 
  public static void main(String[] args) { 
 
    // Wywołuje metodę launch(), która uruchamia aplikację JavaFX. 
    launch(args);   
  } 
 
  // Przesłonięta metoda start(). 
  public void start(Stage myStage) { 
 
    // Określa nazwę obszaru roboczego. 
    myStage.setTitle("Prezentacja pól wyboru"); 
 
    // Tworzy panel FlowPane, który zostanie użyty jako węzeł korzenia. W tym 
    // przypadku odstępy pomiędzy komponentami wynoszą 10.  
    FlowPane rootNode = new FlowPane(10, 10); 
 
    // Wyrównuje kontrolki na scenie do środka. 
    rootNode.setAlignment(Pos.CENTER); 
 
    // Tworzy obiekt sceny. 
    Scene myScene = new Scene(rootNode, 300, 140); 
 
    // Zapisuje obiekt sceny w obszarze roboczym. 
    myStage.setScene(myScene); 
 
    Label heading = new Label("Wybór opcji uruchamia"); 
 
    // Tworzy etykietę, która będzie używana do wyświetlania 
    // stanu pola wyboru.
    response = new Label("Nie zaznaczono żadnej opcji"); 
 
    // Tworzy etykietę informującą o wszystkich wybranych opcjach.
    allTargets = new Label("Lista docelowa: <brak>"); 
 
    // Tworzy pola wyboru. 
    cbWeb = new CheckBox("WWW"); 
    cbDesktop = new CheckBox("Komputer"); 
    cbMobile = new CheckBox("Urządzenie mobilne"); 
 
    // włączenie stanu nieokreślonego przycisków
    //cbWeb.setAllowIndeterminate(true);
    //cbDesktop.setAllowIndeterminate(true);
    //cbMobile.setAllowIndeterminate(true);

    // Obsługa zdarzeń pól wyboru. 
    cbWeb.setOnAction(new EventHandler<ActionEvent>() { 
      public void handle(ActionEvent ae) { 
        if(cbWeb.isSelected()) 
          response.setText("WWW - zaznaczono pole."); 
        else 
          response.setText("WWW - usunięto zaznaczenie pola."); 
 
        showAll(); 
      } 
    }); 

    /*
    cbWeb.setOnAction(new EventHandler<ActionEvent>() {
      public void handle(ActionEvent ae) {
        if(cbWeb.isIndeterminate())
          response.setText("WWW - stan nieokreślony.");
        else if(cbWeb.isSelected())
          response.setText("WWWW - zaznaczono pole.");
        else
          response.setText("WWW - usunięto zaznaczenie pola.");

        showAll();
      }
    });
    */


 
    cbDesktop.setOnAction(new EventHandler<ActionEvent>() { 
      public void handle(ActionEvent ae) { 
        if(cbDesktop.isSelected()) 
          response.setText("Komputer - zaznaczono pole."); 
        else 
          response.setText("Komputer - usunięto zaznaczenie pola."); 
 
        showAll(); 
      } 
    }); 
 
    cbMobile.setOnAction(new EventHandler<ActionEvent>() { 
      public void handle(ActionEvent ae) { 
        if(cbMobile.isSelected()) 
          response.setText("Urządzenie mobilne - zaznaczono pole."); 
        else 
          response.setText("Urządzenie mobilne - usunięto zaznaczenie pola."); 
 
        showAll(); 
      } 
    }); 
 
    // Tworzy separator, by poprawić wygląd układu. 
    Separator separator = new Separator(); 
    separator.setPrefWidth(260); 
 
    // Dodaje wszystkie kontrolki do grafu sceny. 
    rootNode.getChildren().addAll(heading, separator, cbWeb, cbDesktop, 
                                  cbMobile, response, allTargets); 
 
    // Wyświetla obszar roboczy i scenę. 
    myStage.show(); 
  } 
 
  // Aktualizacja i wyświetlenie listy docelowej. 
  void showAll() { 
    targets = ""; 
    if(cbWeb.isSelected()) targets = "WWW "; 
    if(cbDesktop.isSelected()) targets += "Komputer "; 
    if(cbMobile.isSelected()) targets += "Urządzenie mobilne"; 
 
    if(targets.equals("")) targets = "<brak>"; 
 
    allTargets.setText("Lista docelowa: " + targets); 
  } 
}
