// Prezentacja rysowania. 
 
import javafx.application.*; 
import javafx.scene.*; 
import javafx.stage.*; 
import javafx.scene.layout.*; 
import javafx.scene.control.*; 
import javafx.event.*; 
import javafx.geometry.*; 
import javafx.scene.shape.*; 
import javafx.scene.canvas.*; 
import javafx.scene.paint.*; 
import javafx.scene.text.*; 
 
public class DirectDrawDemo extends Application { 
 
  GraphicsContext gc; 
 
  Color[] colors = { Color.RED, Color.BLUE, Color.GREEN, Color.BLACK }; 
  int colorIdx = 0; 
 
  public static void main(String[] args) { 
 
    // Wywołuje metodę launch(), która uruchamia aplikację JavaFX.
    launch(args);   
  } 
 
  // Przesłonięta metoda start().
  public void start(Stage myStage) { 
 
    // Określa nazwę obszaru roboczego.
    myStage.setTitle("Bezpośrednie rysowanie na płótnie"); 
 
    // Tworzy panel FlowPane, który stanie się węzłem korzenia.
    FlowPane rootNode = new FlowPane(); 
 
    // Wyrównuje kontrolki na scenie do środka.
    rootNode.setAlignment(Pos.CENTER); 
 
    // Tworzy obiekt sceny. 
    Scene myScene = new Scene(rootNode, 450, 450); 
 
    // Zapisuje obiekt sceny w obszarze roboczym.
    myStage.setScene(myScene); 
 
    // Tworzy obiekt Canvas. 
    Canvas myCanvas = new Canvas(400, 400); 
   
    // Pobiera kontekst graficzny obiektu Canvas. 
    gc = myCanvas.getGraphicsContext2D(); 
 
    // Tworzy przycisk. 
    Button btnChangeColor = new Button("Zmień kolor"); 
 
    // Obsługa zdarzeń przycisku "Zmień kolor"
    btnChangeColor.setOnAction(new EventHandler<ActionEvent>() { 
      public void handle(ActionEvent ae) { 
 
        // Określa kolor pociągnięcia i wypełnienia.
        gc.setStroke(colors[colorIdx]); 
        gc.setFill(colors[colorIdx]); 
 
        // Przerysowuje linię, tekst i wypełniony prostokąt 
        // w nowym kolorze. Kolor pozostałych węzłów nie jest 
        // zmieniany. 
        gc.strokeLine(0, 0, 200, 200); 
        gc.fillText("Tekst wyświetlony na płótnie.", 60, 50); 
        gc.fillRect(100, 320, 300, 40); 
 
        // Zmienia kolor. 
        colorIdx++; 
        if(colorIdx == colors.length) colorIdx= 0; 
      } 
    }); 
 
    // Rysuje początkową zawartość płótna. 
    gc.strokeLine(0, 0, 200, 200); 
    gc.strokeOval(100, 100, 200, 200); 
    gc.strokeRect(0, 200, 50, 200); 
    gc.fillOval(0, 0, 20, 20); 
    gc.fillRect(100, 320, 300, 40); 
 
    // Ustawia wielkość czcionki na 20 i wyświetla tekst. 
    gc.setFont(new Font(20)); 
    gc.fillText("Tekst wyświetlony na płótnie.", 60, 50); 
 
    // Dodaje obiekt Canvas i przycisk do grafu sceny.
    rootNode.getChildren().addAll(myCanvas, btnChangeColor); 
 
    // Wyświetla obszar roboczy i scenę. 
    myStage.show(); 
  } 
}
