// Prezentacja menu platformy JavaFX.
  
import javafx.application.*;  
import javafx.scene.*;  
import javafx.stage.*;  
import javafx.scene.layout.*;  
import javafx.scene.control.*;  
import javafx.event.*;  
import javafx.geometry.*;  
  
public class MenuDemo extends Application {  
  
  Label response;  
 
  public static void main(String[] args) {  
  
    // Wywołuje metodę launch(), która uruchamia aplikację JavaFX. 
    launch(args);    
  }  
  
  // Przesłonięta metoda start(). 
  public void start(Stage myStage) {  
  
    // Określa nazwę obszaru roboczego. 
    myStage.setTitle("Prezentacja menu");  
  
    // Tworzy panel BorderPane, który zostanie użyty jako węzeł korzenia.       
    BorderPane rootNode = new BorderPane();  
  
     // Tworzy obiekt sceny.
    Scene myScene = new Scene(rootNode, 300, 300);  
  
    // Zapisuje obiekt sceny w obszarze roboczym.
    myStage.setScene(myScene);  
  
    // Tworzy etykietę, w której będą wyświetlane wybierane opcje menu.
    response = new Label("Prezentacja menu.");  
  
    // Tworzy pasek menu. 
    MenuBar mb = new MenuBar(); 
 
    // Tworzy menu Plik. 
    Menu fileMenu = new Menu("Plik"); 
    MenuItem open = new MenuItem("Otwórz"); 
    MenuItem close = new MenuItem("Zamknij"); 
    MenuItem save = new MenuItem("Zapisz"); 
    MenuItem exit = new MenuItem("Zakończ"); 
    fileMenu.getItems().addAll(open, close, save, 
                               new SeparatorMenuItem(), exit); 
 
    // Dodaje menu Plik do paska menu.
    mb.getMenus().add(fileMenu); 
 
    // Tworzy menu Opcje. 
    Menu optionsMenu = new Menu("Opcje"); 
 
    // Tworzy podmenu Kolory.
    Menu colorsMenu = new Menu("Kolory"); 
    MenuItem red = new MenuItem("Czerwony"); 
    MenuItem green = new MenuItem("Zielony"); 
    MenuItem blue = new MenuItem("Niebieski"); 
    colorsMenu.getItems().addAll(red, green, blue); 
    optionsMenu.getItems().add(colorsMenu); 
 
    // Tworzy podmenu Priorytet.
    Menu priorityMenu = new Menu("Priorytet"); 
    MenuItem high = new MenuItem("Wysoki"); 
    MenuItem low = new MenuItem("Niski"); 
    priorityMenu.getItems().addAll(high, low); 
    optionsMenu.getItems().add(priorityMenu); 
 
    // Dodaje separator. 
    optionsMenu.getItems().add(new SeparatorMenuItem()); 
 
    // Tworzy opcję Resetuj. 
    MenuItem reset = new MenuItem("Resetuj"); 
    optionsMenu.getItems().add(reset); 
 
    // Dodaje menu Opcje do paska menu.
    mb.getMenus().add(optionsMenu); 
 
    // Tworzy menu Pomoc. 
    Menu helpMenu = new Menu("Pomoc"); 
    MenuItem about = new MenuItem("O programie"); 
    helpMenu.getItems().add(about); 
 
    // Dodaje menu Pomoc do paska menu. 
    mb.getMenus().add(helpMenu); 
   
    // Obsługa zdarzeń ActionEvent generowanych podczas wybierania
    // opcji menu. 
    EventHandler<ActionEvent> MEHandler = 
                                new EventHandler<ActionEvent>() { 
      public void handle(ActionEvent ae) {  
        String name = ((MenuItem)ae.getTarget()).getText(); 
 
        // W przypadku wybrania opcji Zakończ należy zakończyć 
        // działanie programu. 
        if(name.equals("Zakończ")) Platform.exit(); 
 
        response.setText( "Wybrano " + name); 
      }  
    };
  
    // Określenie obiektów nasłuchujących zdarzeń w poszczególnych elementach menu.
    open.setOnAction(MEHandler); 
    close.setOnAction(MEHandler); 
    save.setOnAction(MEHandler); 
    exit.setOnAction(MEHandler); 
    red.setOnAction(MEHandler); 
    green.setOnAction(MEHandler); 
    blue.setOnAction(MEHandler); 
    high.setOnAction(MEHandler); 
    low.setOnAction(MEHandler); 
    reset.setOnAction(MEHandler); 
    about.setOnAction(MEHandler); 
 
    // Dodaje pasek menu do górnego obszaru panelu BorderPane
    // oraz etykietę do obszaru środkowego.
    rootNode.setTop(mb); 
    rootNode.setCenter(response); 
  
    // Wyświetla obszar roboczy i scenę.
    myStage.show();  
  }  
}
