package rozdzial32;

import javafx.animation.KeyFrame;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.util.Duration;

import javax.swing.*;

public class Listing32_05 {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame("JavaFX w Swingu");
            frame.setBounds(0, 0, 600, 500);
            final JFXPanel fxPanel = new JFXPanel();
            frame.add(fxPanel);
            frame.setVisible(true);
            frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
            Platform.runLater(() -> {
                Image image = new Image(
                        "file:src/resources/kwiatek.jpg");
                ImageView iv = new ImageView();
                iv.setImage(image);
                iv.setFitWidth(256);
                iv.setFitHeight(192);
                iv.setSmooth(true);
                iv.setCache(true);
                iv.relocate(100, 75);
                Pane root = new Pane();
                root.getChildren().add(iv);
                EventHandler<ActionEvent> ev = new EventHandler<>() {
                    double dx = 5;
                    double dy = 3;

                    @Override
                    public void handle(ActionEvent t) {
                        iv.setLayoutX(iv.getLayoutX() + dx);
                        iv.setLayoutY(iv.getLayoutY() + dy);
                        Bounds bounds = root.getBoundsInLocal();
                        if (iv.getLayoutX() <= (bounds.getMinX())
                                || iv.getLayoutX() >=
                                (bounds.getMaxX() - iv.getFitWidth())) {
                            dx = -dx;
                        }
                        if (iv.getLayoutY() >= (bounds.getMaxY() -
                                iv.getFitHeight())
                                || iv.getLayoutY() <= (bounds.getMinY())) {
                            dy = -dy;
                        }
                    }
                };
                Timeline timeline = new Timeline(
                        new KeyFrame(Duration.millis(40),ev));
                timeline.setCycleCount(Timeline.INDEFINITE);
                timeline.play();
                Scene scene = new Scene(root, 600, 500, Color.WHITE);
                fxPanel.setScene(scene);
            });
        });
    }
}
