package rozdzial31;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.VBox;
import javafx.scene.web.PopupFeatures;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.util.Callback;

import java.net.URL;

public class Listing31_07 extends Application {

    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            VBox root = new VBox();
            WebView wv = new WebView();
            WebEngine we = wv.getEngine();
            URL url = this.getClass().getClassLoader().getResource("resources/html/popup.html");
            if (url != null) {
                we.load(url.toExternalForm());
            }
            we.setCreatePopupHandler(new Callback<PopupFeatures, WebEngine>() {
                @Override
                public WebEngine call(PopupFeatures param) {
                    return we;
                }
            });
            root.getChildren().add(wv);
            Scene scene = new Scene(root, 560, 360);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
