package rozdzial28;

import javafx.application.Application;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

import java.util.Arrays;

public class Listing28_09 extends Application {
    private Label label;
    Service<String> lottoService;

    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            lottoService = new Service<>() {
                @Override
                protected Task<String> createTask() {
                    return new Task<>() {
                        @Override
                        protected String call() throws Exception {
                            return withoutReturn(6, 49, true);
                        }
                    };
                }
            };
            lottoService.start();
            VBox vbox = new VBox();
            HBox hbox = new HBox();
            Scene scene = new Scene(vbox, 200, 200);
            label = new Label("Kliknij przycisk 'Losuj'");
            Button start = new Button("Losuj");
            //start.setOnAction(e -> task());
            start.setOnAction(event -> {
                label.setText("lotto: " + lottoService.getValue());
                lottoService.restart();
            });
            Button end = new Button("Zakończ");
            end.setOnAction(e -> stage.close());
            hbox.setSpacing(5);
            hbox.getChildren().addAll(start, end);
            vbox.setSpacing(150);
            vbox.getChildren().addAll(label, hbox);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Zwraca tablice k liczb wybraych losowo z tablicy od 1 do n liczb bez
     * zwracania (powtórzeń)
     *
     * @param k      int - liczba wybieranych liczb
     * @param n      int - największa liczba
     * @param sorted boolean - określa czy wyjściowa tablica liczb będzie
     *               posortowana czy nie, <code>true</code> oznacza tablicę posortowaną, <code>false</code>
     *               oznacza tablicę nie sortowaną
     * @return int[] - tablica wybranych liczb
     */
    public static String withoutReturn(int k, int n, boolean sorted) {
        int[] wynik = new int[k];
        if (k > n) {
            System.out
                    .println("pierwsza liczba nie moze byc wieksza od drugiej");
        } else {
            int[] liczby = new int[n];
            for (int j = 0; j < liczby.length; j++) {
                liczby[j] = j + 1;
            }
            for (int i = 0; i < wynik.length; i++) {
                int l = (int) Math.floor(Math.random() * n);
                wynik[i] = liczby[l];
                liczby[l] = liczby[n - 1];
                n--;
            }
            if (sorted) {
                Arrays.sort(wynik);
            }
        }
        return Arrays.toString(wynik);
    }
}
