package rozdzial24;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.image.*;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Listing24_13 extends Application {
    BufferedInputStream bis;
    FileInputStream is;

    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            is = new FileInputStream(new File("src/rozdzial24/kwiatek3.jpg"));
            bis = new BufferedInputStream(is);
            Image image = new Image(bis);
            ImageView imageView = new ImageView(image);
            StackPane root = new StackPane();
            root.getChildren().add(imageView);
            Scene scene = new Scene(root);
            stage.setScene(scene);
            stage.show();
            PixelReader pr = image.getPixelReader();
            int x = 0;
            int y = 0;
            int w = 120;
            int h = 120;
            WritablePixelFormat<ByteBuffer> wpf1 = PixelFormat
                    .getByteBgraInstance();
            byte[] buffer = new byte[w * h * 4];
            int offset = 0;
            int scanlineStride = w * 4;
            pr.getPixels(x, y, w, h, wpf1, buffer, offset, scanlineStride);
            int row = 100;
            int col = 100;
            int b = buffer[row * w * 4 + col * 4 + 0] & 0xff;
            int g = buffer[row * w * 4 + col * 4 + 1] & 0xff;
            int r = buffer[row * w * 4 + col * 4 + 2] & 0xff;
            int a = buffer[row * w * 4 + col * 4 + 3] & 0xff;
            System.out.print(a + ", " + r + ", " + g + ", " + b);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
        if (bis != null) {
            try {
                bis.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (is != null) {
            try {
                is.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}
