package rozdzial24;

import javafx.scene.paint.Color;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public interface IOUtil {
    /**
     * Przeksztalca ścieżkę do pliku w adres URL
     *
     * @param path String - ścieżka do pliku
     * @return URL - adres URL
     */
    static URL fileToURL(String path) {
        File file = new File(path);
        URI uri = file.toURI();
        URL url = null;
        try {
            url = uri.toURL();
        } catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return url;
    }

    /**
     * Przeksztalca ścieżkę do pliku w adres URL
     *
     * @param file File - ścieżka do pliku
     * @return URL - adres URL
     */
    static URL fileToURL(File file) {
        URI uri = file.toURI();
        URL url = null;
        try {
            url = uri.toURL();
        } catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return url;
    }

    static int ARGBtoInt(int a, int r, int g, int b) {
        return (a << 24) | (r << 16) | (g << 8) | b;
    }

    static int[] intToARGB(int argb) {
        int A = (argb >> 24) & 0xff;
        int R = (argb >> 16) & 0xff;
        int G = (argb >> 8) & 0xff;
        int B = argb & 0xff;
        return new int[]{A, R, G, B};
    }

    //przelicza indeks z [][] na []
    static int index(int row, int col, int cols) {
        return row * cols + col;
    }

    /**
     * przelicza indeks tablicy lub arraylisty na rzad i kolumne
     * macierzy
     *
     * @param indeks int - indeks tablicy
     * @param cols   - int - liczba kolumn
     * @return int[] tablica intow [0] rząd macierzy, [1] kolumna macierzy
     */
    static int[] obliczRowCol(int indeks, int cols) {
        int row = indeks / cols;
        int col = indeks % cols;
        return new int[]{row, col};
    }

    static Color gray(Color color) {
        double a = color.getOpacity();
        double r = color.getRed() * 255;
        double g = color.getGreen() * 255;
        double b = color.getBlue() * 255;
        int gray = (int) (0.33 * r + 0.56 * g + 0.11 * b);
        return Color.rgb(gray, gray, gray, a);
    }
}
