package rozdzial27;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.VBox;
import javafx.scene.web.HTMLEditor;
import javafx.stage.Stage;

public class Listing27_02 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            VBox root = new VBox();
            //
            Label label = new Label("Przeciągnij tutaj tekst html");
            //
            HTMLEditor hte = new HTMLEditor();
            hte.setPrefWidth(380);
            hte.setPrefHeight(380);
            //
            Button but = new Button("Usuń zawartość");
            but.setOnAction(e -> hte.setHtmlText(""));
            root.getChildren().addAll(label, hte, but);
            Scene scene = new Scene(root, 400, 440);
            scene.setOnDragOver(e -> {
                Dragboard dbo = e.getDragboard();
                if (dbo.hasHtml()) {
                    e.acceptTransferModes(TransferMode.COPY);
                }
                e.consume();
            });
            scene.setOnDragDropped(e -> {
                boolean done = false;
                Dragboard dbo = e.getDragboard();
                if (dbo.hasHtml()) {
                    String txt = dbo.getString();
                    hte.setHtmlText(txt);
                    done = true;
                }
                e.setDropCompleted(done);
                e.consume();
            });
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
