package rozdzial23;

import javafx.application.*;
import javafx.collections.*;
import javafx.scene.*;
import javafx.scene.chart.*;
import javafx.scene.layout.*;
import javafx.stage.*;

public class Listing23_07 extends Application{
	public static void main(String[] args) {
		Application.launch(args);
	}

	@Override
	public void start(Stage stage) {
		try{
			ObservableList<XYChart.Series<Number, Number>> vBarData = ChartData
					.dane2a();
			for(XYChart.Series<Number, Number> s : vBarData){
				for(XYChart.Data<Number, Number> d : s.getData()){
					d.setExtraValue(0.5);
				}
			}
			NumberAxis xAxis = new NumberAxis();
			xAxis.setLabel("Lata");
			xAxis.setAutoRanging(false);
			xAxis.setLowerBound(0);
			xAxis.setUpperBound(9);
			xAxis.setTickUnit(1);
			xAxis.setMinorTickVisible(false);
			NumberAxis yAxis = new NumberAxis();
			yAxis.setLabel("Nakłady  w mln zł");
			BubbleChart<Number, Number> vBar = new BubbleChart<>(
					xAxis, yAxis, vBarData);
			vBar.setTitle("Wartość nakładów");
			StackPane root = new StackPane();
			root.getChildren().add(vBar);
			Scene scene = new Scene(root, 560, 300);
			stage.setScene(scene);
			stage.show();
		} catch (Exception e){
			e.printStackTrace();
		}
	}
}
