package rozdzial13;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.effect.Blend;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.ColorInput;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;

public class Listing13_13 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            Pane root = new Pane();
            //rectangle
            ColorInput rect1 = new ColorInput(220, 20, 150, 150,
                    Color.AQUAMARINE);
            ColorInput rect2 = new ColorInput(250, 80, 150, 150,
                    Color.ROSYBROWN);
            //efekt
            Blend ds = new Blend();
            ds.setTopInput(rect1);
            ds.setBottomInput(rect2);
            ds.setMode(BlendMode.MULTIPLY);
            //rectangle
            Rectangle rect = new Rectangle(460, 250);
            rect.setEffect(ds);
            System.out.println(rect.getFill());
            //slider 1
            Slider oxslider = new Slider(0.0, 1.0, 0.75);
            oxslider.setLayoutX(60);
            oxslider.setLayoutY(20);
            oxslider.setMajorTickUnit(0.1);
            oxslider.setShowTickLabels(true);
            oxslider.setShowTickMarks(true);
            ds.opacityProperty().bind(oxslider.valueProperty());
            Label oxslabel = new Label("opacity: ");
            oxslabel.setLabelFor(oxslider);
            oxslabel.setLayoutX(20);
            oxslabel.setLayoutY(20);
            //colorPicker
            ColorPicker cpicker1 = new ColorPicker(Color.BLUEVIOLET);
            cpicker1.setLayoutX(80);
            cpicker1.setLayoutY(60);
            rect1.paintProperty().bind(cpicker1.valueProperty());
            Label cp1label = new Label("topInput: ");
            cp1label.setLabelFor(cpicker1);
            cp1label.setLayoutX(20);
            cp1label.setLayoutY(60);
            //-
            ComboBox<BlendMode> cbox = new ComboBox<>();
            cbox.getItems().addAll(BlendMode.values());
            cbox.setLayoutX(80);
            cbox.setLayoutY(100);
            cbox.setValue(ds.getMode());
            ds.modeProperty().bind(cbox.valueProperty());
            Label cb1label = new Label("BlendMode: ");
            cb1label.setLabelFor(cbox);
            cb1label.setLayoutX(20);
            cb1label.setLayoutY(100);
            //
            //colorPicker
            ColorPicker cpicker2 = new ColorPicker(Color.DARKORANGE);
            cpicker2.setLayoutX(90);
            cpicker2.setLayoutY(140);
            rect2.paintProperty().bind(cpicker2.valueProperty());
            Label cp2label = new Label("bottomInput: ");
            cp2label.setLabelFor(cpicker1);
            cp2label.setLayoutX(20);
            cp2label.setLayoutY(140);
            //-
            root.getChildren().addAll(oxslabel, oxslider, cp1label, cpicker1,
                    cb1label, cbox, cp2label, cpicker2, rect);
            Scene scene = new Scene(root, 460, 250);
            stage.setScene(scene);
            stage.setTitle("Blend");
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
