package rozdzial13;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.effect.Bloom;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class Listing13_07 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            LinearGradient lg1 = new LinearGradient(0, 0, 1, 0, true,
                    CycleMethod.NO_CYCLE, new Stop(0, Color.WHITE),
                    new Stop(1, Color.BLACK));
            Pane root = new Pane();
            Text text = new Text("Shadow");
            text.setX(220);
            text.setY(100);
            text.setFill(lg1);
            text.setFont(Font.font(null, FontWeight.BOLD, 80));
            //efekt
            Bloom ds = new Bloom();
            text.setEffect(ds);
            //slider 3
            Slider cslider = new Slider(0.0, 1.0, 0.3);
            cslider.setLayoutX(80);
            cslider.setLayoutY(100);
            cslider.setMajorTickUnit(0.1);
            cslider.setShowTickLabels(true);
            cslider.setShowTickMarks(true);
            ds.thresholdProperty().bind(cslider.valueProperty());
            Label slabel = new Label("threshold: ");
            slabel.setLabelFor(cslider);
            slabel.setLayoutX(20);
            slabel.setLayoutY(100);
            //
            root.getChildren().addAll(cslider, slabel, text);
            Scene scene = new Scene(root, 560, 280);
            scene.setFill(Color.WHITE);
            stage.setScene(scene);
            stage.setTitle("Bloom");
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
