package rozdzial32;

import java.awt.*;
import java.io.Serial;
import javax.swing.*;
/**
 * animacja karty odbijającej się od brzegów panelu CardPanel implementuje
 * Runnable
 */
public class CardPanel extends JPanel implements Runnable{
	@Serial
	private static final long serialVersionUID = -1708095494186169452L;
	private volatile boolean exit = false;
	private final Card card;
	private double x = 0;
	private double y = 0;
	private double dx = 1;
	private double dy = 1;

	public CardPanel(){
		setPreferredSize(new Dimension(800, 800));
		setLayout(null);
		setBounds(0, 0, 800, 800);
		card = new Card("src/resources/assets/AW1.jpg");
		add(card);
	}

	@Override
	public void run() {
		while(!exit){
			move(CardPanel.this);
			card.setLocation((int)x, (int)y);
			CardPanel.this.repaint();
			try{
				Thread.sleep(5);
			} catch (InterruptedException e){
				e.printStackTrace();
			}
		}
	}

	public void move(JPanel panel) {
		x += dx;
		y += dy;
		if(x < panel.getBounds().getMinX()){
			x = panel.getBounds().getMinX();
			dx = -dx;
		}
		if(x + Card.XSIZE >= panel.getBounds().getMaxX()){
			x = panel.getBounds().getMaxX() - Card.XSIZE;
			dx = -dx;
		}
		if(y < panel.getBounds().getMinY()){
			y = panel.getBounds().getMinY();
			dy = -dy;
		}
		if(y + Card.YSIZE >= panel.getBounds().getMaxY()){
			y = panel.getBounds().getMaxY() - Card.YSIZE;
			dy = -dy;
		}
	}
	public void stop(){
		exit=true;
	}
}
