package rozdzial32;

import java.awt.*;
import java.awt.image.*;
import java.io.Serial;
import javax.swing.*;

public class Card extends JComponent{
	@Serial
	private static final long serialVersionUID = 5586338595500806338L;
	public static final int XSIZE = 182;
	public static final int YSIZE = 335;
	private final BufferedImage bimage;

	public Card(String obrazek){
		bimage = fileToBimage3(obrazek);
		setLayout(null);
		setBounds(0, 0, XSIZE, YSIZE);
		setPreferredSize(new Dimension(XSIZE, YSIZE));
	}

	@Override
	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		Graphics2D g2 = (Graphics2D)g;
		g2.drawImage(bimage, 0, 0, XSIZE, YSIZE, this);
	}
	public static BufferedImage fileToBimage3(String plik) {
		Image obrazek = loadImage(plik);
		BufferedImage bimage;
		GraphicsConfiguration gc = GraphicsEnvironment
				.getLocalGraphicsEnvironment().getDefaultScreenDevice()
				.getDefaultConfiguration();
		bimage = gc.createCompatibleImage(obrazek.getWidth(null),
				obrazek.getHeight(null));
		bimage.getGraphics().drawImage(obrazek, 0, 0, null);
		return bimage;
	}
	public static Image loadImage(String obrazek) {
		Image image = Toolkit.getDefaultToolkit().getImage(obrazek);
		MediaTracker mt = new MediaTracker(new JPanel());
		mt.addImage(image, 0);
		try{
			mt.waitForID(0);
		} catch (InterruptedException e){
			e.printStackTrace();
		}
		return image;
	}
}
