package rozdzial26;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.stage.Stage;
import javafx.util.Duration;
import rozdzial24.IOUtil;

import java.net.URL;

public class Listing26_10 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            URL url = IOUtil.fileToURL("src/resources/assets/ziggurat.mp4");
            VBox root = new VBox();
            Media media = new Media(url.toString());
            MediaPlayer mp = new MediaPlayer(media);
            mp.setAutoPlay(false);
            mp.currentTimeProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.lessThan(Duration.seconds(140))) {
                    mp.setRate(6.0);
                } else {
                    mp.setRate(1.0);
                }
            });
            MediaView mv = new MediaView(mp);
            mv.setFitWidth(320);
            mv.setFitHeight(240);
            Button start = new Button("Start");
            start.setOnAction(e -> mp.play());
            Button pause = new Button("Pauza");
            pause.setOnAction(e -> mp.pause());
            Button stop = new Button("Stop");
            stop.setOnAction(e -> mp.stop());
            HBox hbox = new HBox();
            hbox.getChildren().addAll(start, pause, stop);
            root.getChildren().addAll(mv, hbox);
            Scene scene = new Scene(root, 340, 280);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
