package dodatki.robot_awt;

import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Synthesizer;
import javax.swing.*;
import java.awt.*;

public class Piano {


    public Piano() throws MidiUnavailableException {
        final int[] white = {21, 23,
                24, 26, 28, 29, 31, 33, 35,
                36, 38, 40, 41, 43, 45, 47,
                48, 50, 52, 53, 55, 57, 59,
                60, 62, 64, 65, 67, 69, 71,
                72, 74, 76, 77, 79, 81, 83,
                84, 86, 88, 89, 91, 93, 95,
                96, 98, 100, 101, 103, 105, 107,
                108
        };
        final int velocity = 64;
        final int keys = 52;
        final int white_button_width = 20;
        final int white_button_height = 120;
        final int frame_height = white_button_height + 30;
        final int black_button_width = 16;
        final int black_button_height = 80;
        Synthesizer synthesizer = MidiSystem.getSynthesizer();
        synthesizer.open();
        MidiChannel channel = synthesizer.getChannels()[0];
        JFrame frame = new JFrame("Fortepian");
        JLayeredPane pane = new JLayeredPane();
        frame.add(pane);
        for (int i = 0; i < keys; i++) {
            JButton w = new JButton();
            w.setBackground(Color.WHITE);
            w.setLocation(i * white_button_width, 0);
            w.setSize(white_button_width, white_button_height);
            final int note = white[i];
            w.addActionListener(e -> channel.noteOn(note, velocity));
            pane.add(w, 0, -1);
        }
        for (int i = 0; i < keys - 1; i++) {
            int j = i % 7;
            if (j == 1 || j == 4) {
                continue;
            }
            JButton b = new JButton();
            b.setBackground(Color.BLACK);
            b.setLocation(i * white_button_width + black_button_width * 3 / 4, 0);
            b.setSize(black_button_width, black_button_height);
            final int note = white[i] + 1;
            b.addActionListener(e -> channel.noteOn(note, velocity));
            pane.add(b, 1, -1);
        }
        frame.setSize(keys * white_button_width + 20, frame_height);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }
}
